/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.enums;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum ProductTypeEnum {
    barricade("barricade", "\u5347\u964d\u8def\u969c", "4", "device_data_barricade"),
    hazard("hazard", "\u5371\u9669\u6e90\u76d1\u6d4b", "3", "device_data_water"),
    water("water", "\u4f4e\u6d3c\u79ef\u6c34\u76d1\u6d4b", "2", "device_data_hazard"),
    signboaerd("signboaerd", "\u6807\u8bc6\u724c\u76d1\u6d4b", "1", "device_data_signboaerd");

    private String code;
    private String desc;
    private String type;
    private String table;

    private ProductTypeEnum(String code, String desc, String type, String table) {
        this.code = code;
        this.desc = desc;
        this.type = type;
        this.table = table;
    }

    public static String findByCode(String code) {
        ProductTypeEnum[] values;
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (ProductTypeEnum state : values = ProductTypeEnum.values()) {
            if (!state.getCode().equals(code)) continue;
            return state.getDesc();
        }
        return null;
    }

    public static ProductTypeEnum getByType(String val) {
        ProductTypeEnum[] values = ProductTypeEnum.values();
        Optional<ProductTypeEnum> first = Arrays.stream(values).filter(e -> e.getCode().equals(val)).findFirst();
        return !first.isPresent() ? null : first.get();
    }

    public static String getType(String code) {
        ProductTypeEnum[] values;
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (ProductTypeEnum state : values = ProductTypeEnum.values()) {
            if (!state.getCode().equals(code)) continue;
            return state.getType();
        }
        return null;
    }

    public static String getTable(String code) {
        ProductTypeEnum[] values;
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (ProductTypeEnum v : values = ProductTypeEnum.values()) {
            if (!v.getCode().equals(code)) continue;
            return v.getTable();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }

    public String getTable() {
        return this.table;
    }
}

