/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.controller;

import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class BaseController<M extends BaseManager<T>, T extends Model<T>> {
    @Autowired
    protected M baseService;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) T t) {
        boolean result = this.baseService.save(t);
        if (!result) {
            return new CommonResult<Object>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<T> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<T> queryFilter) {
        return this.baseService.query(queryFilter);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public T getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return (T)((Model)this.baseService.getById((Serializable)((Object)id)));
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) T t) {
        boolean result = this.baseService.updateById(t);
        if (!result) {
            return new CommonResult<String>(ResponseErrorEnums.FAIL_OPTION, "\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult<String>();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = this.baseService.removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult<String>(ResponseErrorEnums.FAIL_OPTION, "\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult<String>();
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = this.baseService.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<String>(ResponseErrorEnums.FAIL_OPTION, "\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult<String>();
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        if (!params.isEmpty()) {
            this.baseService.updateSequence(params);
        }
        return new CommonResult<String>(true, "\u6392\u5e8f\u5b8c\u6210");
    }
}

