/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.conf.JwtConfig;
import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.conf.SsoConfig;
import com.artfess.base.exception.CertificateException;
import com.artfess.base.exception.ServerRejectException;
import com.artfess.base.feign.ApplicationFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.jwt.JwtAuthenticationRequest;
import com.artfess.base.jwt.JwtAuthenticationResponse;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.model.CommonResult;
import com.artfess.base.service.LoginLogService;
import com.artfess.base.service.LoginUserService;
import com.artfess.base.service.PwdStrategyService;
import com.artfess.base.service.SecurityMachinePersonService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FluentUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.IPUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.XmlUtil;
import com.artfess.uc.api.model.IUser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8ba4\u8bc1\u63a5\u53e3"})
@ApiGroup(group={"group_bpm", "group_form", "group_system", "group_uc"})
public class AuthenticationRestController {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationRestController.class);
    @Resource
    AuthenticationManager authenticationManager;
    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    UserDetailsService userDetailsService;
    @Resource
    SsoConfig ssoConfig;
    @Value(value="${system.mode.demo:false}")
    protected boolean demoMode;
    @Resource
    UCFeignService uCFeignService;
    @Resource
    ApplicationFeignService applicationFeignService;
    @Resource
    LoginLogService loginLogService;
    @Resource
    LoginUserService loginUserService;
    @Resource
    SaaSConfig saasConfig;
    @Resource
    JwtConfig jwtConfig;

    private void deleteUserDetailsCache(String userAccount) {
        AuthenticationRestController bean = (AuthenticationRestController)AppUtil.getBean(this.getClass());
        bean.delUserDetailsCache(userAccount);
        bean.delUsernamesCache(userAccount);
    }

    @CacheEvict(value={"bpm:uc:userAccount"}, key="#userAccount")
    protected void delUserDetailsCache(String userAccount) {
    }

    @CacheEvict(value={"bpm:uc:userName"}, key="#userAccount")
    protected void delUsernamesCache(String userAccount) {
    }

    @RequestMapping(value={"/auth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u767b\u5f55\u7cfb\u7edf", httpMethod="POST", notes="\u767b\u5f55\u7cfb\u7edf")
    public ResponseEntity<?> createAuthenticationToken(@RequestBody JwtAuthenticationRequest authenticationRequest) throws AuthenticationException, CertificateException {
        List<String> machineIdList;
        SecurityMachinePersonService machineService;
        String errorMsg;
        String reqPassword;
        String reqAccount;
        block13: {
            reqAccount = authenticationRequest.getUsername();
            reqPassword = "";
            this.deleteUserDetailsCache(reqAccount);
            errorMsg = "";
            try {
                reqPassword = Base64.getFromBase64(authenticationRequest.getPassword());
                this.authenticate(reqAccount, reqPassword);
            }
            catch (Exception e) {
                logger.error(String.format("Login failed account[%s].", reqAccount), (Throwable)e);
                errorMsg = "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";
                if (BeanUtils.isNotEmpty(e.getCause()) && e.getCause() instanceof CertificateException) {
                    CertificateException ce = (CertificateException)e.getCause();
                    errorMsg = ce.getMessage();
                }
                if (!(e instanceof LockedException)) break block13;
                errorMsg = "\u8d26\u53f7\u88ab\u7981\u7528\u6216\u79bb\u804c";
            }
        }
        HttpServletRequest request = HttpUtil.getRequest();
        HttpSession session = request.getSession();
        String IP = IPUtils.getIpAddr(request);
        if (StringUtil.isNotEmpty(errorMsg)) {
            JsonNode json;
            PwdStrategyService service;
            if (errorMsg.equals("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef") && !this.isAdmin(reqAccount) && (service = AppUtil.getBean(PwdStrategyService.class)) != null && BeanUtils.isNotEmpty(json = service.getJsonDefault())) {
                int lockStatus = json.get("lockStatus").asInt();
                int lockTimes = json.get("lockTimes").asInt();
                int enable = json.get("enable").asInt();
                if (enable == 1 && lockStatus == 1) {
                    Integer loginTimes = (Integer)session.getAttribute("_loginTime_");
                    if (loginTimes == null) {
                        loginTimes = new Integer(0);
                    }
                    loginTimes = loginTimes + 1;
                    session.setAttribute("_loginTime_", (Object)loginTimes);
                    if (loginTimes >= lockTimes) {
                        this.loginUserService.lockedUser(reqAccount, 2);
                    }
                }
            }
            throw new RuntimeException(errorMsg);
        }
        if (!this.isAdmin(reqAccount) && (machineService = AppUtil.getBean(SecurityMachinePersonService.class)) != null && (machineIdList = machineService.queryPersonLimitByAccount(reqAccount)) != null && machineIdList.size() > 0) {
            boolean allowded = false;
            List<String> ipList = machineService.queryMachineIps(machineIdList);
            if (ipList != null && ipList.size() > 0) {
                for (String ip : ipList) {
                    if (!ip.equals(IP)) continue;
                    allowded = true;
                    break;
                }
            }
            if (!allowded) {
                throw new RuntimeException("\u7528\u6237\u3010" + reqAccount + "\u3011\u5df2\u7ed1\u5b9a\u6d89\u5bc6\u673a\u5668\uff0c\u4e0d\u80fd\u5728\u5f53\u524d\u673a\u5668\u4e0a\u767b\u5f55!");
            }
        }
        boolean isMobile = HttpUtil.isMobile(request);
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(authenticationRequest.getUsername());
        String token = this.jwtTokenHandler.generateToken(userDetails);
        String userName = userDetails.getUsername();
        String account = "";
        String userId = "";
        boolean loginStatus = true;
        HashMap<String, Object> userAttrs = new HashMap<String, Object>();
        if (userDetails instanceof IUser) {
            IUser user = (IUser)userDetails;
            userName = user.getFullname();
            account = user.getAccount();
            userId = user.getUserId();
            request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
            loginStatus = this.checkUser(user, reqPassword);
            userAttrs.put("tenantId", user.getTenantId());
        }
        this.handleSingleLogin(isMobile, MapUtil.getString(userAttrs, "tenantId"), account, token);
        session.removeAttribute("_loginTime_");
        this.loginUserService.updateLastLoginTime(account);
        return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId, this.jwtConfig.getExpirationLong(), loginStatus, userAttrs));
    }

    private boolean isAdmin(String account) {
        String[] split;
        String tmp = "admin";
        for (String _account : split = tmp.split(",")) {
            if (!_account.equals(account)) continue;
            return true;
        }
        return false;
    }

    private String getUserNameWithCas(String ticket, String service) throws IOException {
        String casUserDetail = "";
        String username = null;
        String errorCode = "";
        try {
            casUserDetail = FluentUtil.get(String.format("%s/p3/serviceValidate?ticket=%s&service=%s", this.ssoConfig.getCasUrl(), ticket, service), "");
            String json = XmlUtil.toJson(casUserDetail);
            JsonNode jsonNode = JsonUtil.toJsonNode(json);
            if (jsonNode.has("authenticationSuccess")) {
                username = jsonNode.get("authenticationSuccess").get("user").asText();
            } else if (jsonNode.has("authenticationFailure")) {
                errorCode = jsonNode.get("authenticationFailure").get("code").asText();
                throw new RuntimeException(errorCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u83b7\u53d6cas\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff1a" + casUserDetail);
            throw new RuntimeException("\u83b7\u53d6cas\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff1a " + e.getMessage());
        }
        return username;
    }

    private String getUserNameWithOauth(String code, String service) {
        String userName = null;
        String oauthTokenUrl = this.ssoConfig.getOauthTokenUrl();
        String stufix = String.format("&code=%s&redirect_uri=%s", code, service);
        try {
            String header = this.ssoConfig.getOauthBasicHeader();
            String tokenResult = FluentUtil.post(oauthTokenUrl + stufix, header, null, ContentType.APPLICATION_FORM_URLENCODED);
            JsonNode jsonNode = JsonUtil.toJsonNode(tokenResult);
            if (jsonNode != null && jsonNode.isObject()) {
                String token = jsonNode.get(this.ssoConfig.getOauthAccesstokenKey()).asText();
                String oauthCheckUrl = this.ssoConfig.getOauthCheckUrl();
                String checkResult = FluentUtil.post(oauthCheckUrl + token, null, null, ContentType.APPLICATION_FORM_URLENCODED);
                JsonNode checkJNode = JsonUtil.toJsonNode(checkResult);
                if (checkJNode != null && checkJNode.isObject()) {
                    userName = checkJNode.get(this.ssoConfig.getOauthUsernameKey()).asText();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u83b7\u53d6oauth\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25", e);
        }
        return userName;
    }

    @RequestMapping(value={"/sso/auth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u767b\u5f55\u7cfb\u7edf-\u5355\u70b9\u767b\u5f55", httpMethod="GET", notes="\u767b\u5f55\u7cfb\u7edf-\u5355\u70b9\u767b\u5f55")
    public ResponseEntity<?> ssoAuth(@RequestParam Optional<String> ticket, @RequestParam Optional<String> code, @RequestParam Optional<String> ssoMode, @RequestParam String service) throws AuthenticationException, ClientProtocolException, IOException {
        Assert.isTrue((boolean)this.ssoConfig.isEnable(), (String)"\u5f53\u524d\u670d\u52a1\u672a\u5f00\u542f\u5355\u70b9\u767b\u5f55");
        String username = null;
        String mode = this.ssoConfig.getMode();
        if (ssoMode.isPresent()) {
            mode = ssoMode.get();
        }
        if (ticket.isPresent() && "cas".equals(mode)) {
            username = this.getUserNameWithCas(ticket.get(), service);
        } else if (code.isPresent() && "oauth".equals(mode)) {
            username = this.getUserNameWithOauth(code.get(), service);
        } else if (code.isPresent() && "jwt".equals(mode)) {
            username = this.jwtTokenHandler.getUsernameFromToken(ticket.get());
        } else {
            throw new ServerRejectException("\u5355\u70b9\u767b\u5f55\u6a21\u5f0f\u5339\u914d\u5f02\u5e38");
        }
        this.deleteUserDetailsCache(username);
        HttpServletRequest request = HttpUtil.getRequest();
        boolean isMobile = HttpUtil.isMobile(request);
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        String token = this.jwtTokenHandler.generateToken(userDetails);
        String userName = userDetails.getUsername();
        String account = "";
        String userId = "";
        HashMap<String, Object> userAttrs = new HashMap<String, Object>();
        if (userDetails instanceof IUser) {
            IUser user = (IUser)userDetails;
            userName = user.getFullname();
            account = user.getAccount();
            userId = user.getUserId();
            request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
            userAttrs.put("tenantId", user.getTenantId());
        }
        logger.debug("\u901a\u8fc7\u5355\u70b9\u8ba4\u8bc1\u767b\u5f55\u6210\u529f\u3002");
        if (!code.isPresent() || !"jwt".equals(mode)) {
            this.handleSingleLogin(isMobile, MapUtil.getString(userAttrs, "tenantId"), account, token);
        }
        return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId, this.jwtConfig.getExpirationLong(), userAttrs));
    }

    @RequestMapping(value={"/sso/weixin"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u8fdb\u5165\u624b\u673a\u7aef-\u5355\u70b9\u767b\u5f55", httpMethod="GET", notes="\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u8fdb\u5165\u624b\u673a\u7aef-\u5355\u70b9\u767b\u5f55")
    public ResponseEntity<?> ssoWeixin(@RequestParam Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        String resultJson = HttpUtil.sendHttpsRequest(this.applicationFeignService.getUserInfoUrl("weChatWork", code.get()), "", "POST");
        logger.error("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5f55\u8fd4\u56de\u7ed3\u679c\uff1a" + resultJson);
        ObjectNode result = null;
        try {
            result = (ObjectNode)JsonUtil.toJsonNode(resultJson);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            String wxWorkId = result.get("UserId").asText();
            JsonNode simpleUser = this.uCFeignService.getUserByWxWorkId(wxWorkId);
            if (BeanUtils.isEmpty(simpleUser) || simpleUser.isNull()) {
                throw new RuntimeException("\u67e5\u65e0\u4e0e\u60a8\u4f01\u5fae\u8d26\u53f7[userid:" + wxWorkId + "]\u7ed1\u5b9a\u7684eip\u8d26\u53f7");
            }
            String account = simpleUser.get("account").asText();
            try {
                this.deleteUserDetailsCache(account);
                HttpServletRequest request = HttpUtil.getRequest();
                boolean isMobile = HttpUtil.isMobile(request);
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
                String token = this.jwtTokenHandler.generateToken(userDetails);
                String userName = userDetails.getUsername();
                String userId = "";
                String tenantId = "";
                if (userDetails instanceof IUser) {
                    IUser user = (IUser)userDetails;
                    userName = user.getFullname();
                    userId = user.getUserId();
                    tenantId = user.getTenantId();
                    request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
                }
                logger.debug("\u901a\u8fc7\u5355\u70b9\u8ba4\u8bc1\u767b\u5f55\u6210\u529f\u3002");
                this.handleSingleLogin(isMobile, tenantId, account, token);
                return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId));
            }
            catch (Exception e) {
                throw new RuntimeException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5f55\u5931\u8d25 ,eip\u7528\u6237\u8d26\u53f7:" + account);
            }
        }
        throw new RuntimeException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @RequestMapping(value={"/sso/weixinPublic"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5fae\u4fe1\u516c\u4f17\u53f7\u8fdb\u5165\u624b\u673a\u7aef", httpMethod="GET", notes="\u5fae\u4fe1\u516c\u4f17\u53f7\u8fdb\u5165\u624b\u673a\u7aef")
    public ResponseEntity<?> weixinPublic(@RequestParam Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        String resultJson = HttpUtil.sendHttpsRequest(this.applicationFeignService.getUserInfoUrl("weChatOffAcc", code.get()), "", "POST");
        ObjectNode result = null;
        try {
            result = (ObjectNode)JsonUtil.toJsonNode(resultJson);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (result.has("openid")) {
            String openid = result.get("openid").asText();
            CommonResult<JsonNode> r = this.uCFeignService.getUserByOpenId(openid);
            if (r.getState().booleanValue()) {
                JsonNode node = r.getValue();
                if (StringUtil.isNotEmpty(openid) && BeanUtils.isEmpty(node)) {
                    return ResponseEntity.ok((Object)new JwtAuthenticationResponse(openid));
                }
                String account = node.get("account").asText();
                this.deleteUserDetailsCache(account);
                HttpServletRequest request = HttpUtil.getRequest();
                boolean isMobile = HttpUtil.isMobile(request);
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
                String token = this.jwtTokenHandler.generateToken(userDetails);
                String userName = userDetails.getUsername();
                String userId = "";
                String tenantId = "";
                if (userDetails instanceof IUser) {
                    IUser user = (IUser)userDetails;
                    userName = user.getFullname();
                    userId = user.getUserId();
                    tenantId = user.getTenantId();
                    request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
                }
                this.handleSingleLogin(isMobile, tenantId, account, token);
                return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId));
            }
            if (StringUtil.isNotEmpty(openid)) {
                return ResponseEntity.ok((Object)new JwtAuthenticationResponse(openid));
            }
        }
        throw new RuntimeException("\u5fae\u4fe1\u767b\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @RequestMapping(value={"/sso/dingTalk"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9489\u9489\u8fdb\u5165\u624b\u673a\u7aef", httpMethod="GET", notes="\u5fae\u4fe1\u516c\u4f17\u53f7\u8fdb\u5165\u624b\u673a\u7aef")
    public ResponseEntity<?> dingTalk(@RequestParam Optional<String> code) throws AuthenticationException, ClientProtocolException, IOException {
        String resultJson = HttpUtil.sendHttpsRequest(this.applicationFeignService.getUserInfoUrl("dingtalk", code.get()), "", "GET");
        ObjectNode result = null;
        try {
            result = (ObjectNode)JsonUtil.toJsonNode(resultJson);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (result.has("userid")) {
            String dingtalkId = result.get("userid").asText();
            JsonNode simpleUser = this.uCFeignService.getUserByDingtalkId(dingtalkId);
            if (BeanUtils.isEmpty(simpleUser) || simpleUser.isNull()) {
                throw new RuntimeException("\u67e5\u65e0\u4e0e\u60a8\u9489\u9489\u8d26\u53f7[userid:" + dingtalkId + "]\u7ed1\u5b9a\u7684eip\u8d26\u53f7");
            }
            String account = simpleUser.get("account").asText();
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
            if (BeanUtils.isNotEmpty(userDetails)) {
                this.deleteUserDetailsCache(account);
                HttpServletRequest request = HttpUtil.getRequest();
                boolean isMobile = HttpUtil.isMobile(request);
                String token = this.jwtTokenHandler.generateToken(userDetails);
                String userName = userDetails.getUsername();
                String userId = "";
                String tenantId = "";
                if (userDetails instanceof IUser) {
                    IUser user = (IUser)userDetails;
                    userName = user.getFullname();
                    userId = user.getUserId();
                    tenantId = user.getTenantId();
                    request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
                }
                this.handleSingleLogin(isMobile, tenantId, account, token);
                return ResponseEntity.ok((Object)new JwtAuthenticationResponse(token, userName, account, userId));
            }
            throw new RuntimeException("\u9489\u9489\u767b\u5f55\u5931\u8d25\uff01eip\u8d26\u53f7:" + account + "\u4e0d\u5b58\u5728");
        }
        throw new RuntimeException("\u9489\u9489\u767b\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @RequestMapping(value={"/sso/info"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5355\u70b9\u767b\u5f55\u914d\u7f6e", httpMethod="GET", notes="\u5355\u70b9\u767b\u5f55\u914d\u7f6e")
    public ResponseEntity<Map<String, Object>> isUseCas(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enable", this.ssoConfig.isEnable());
        map.put("ssoUrl", this.ssoConfig.getSsoUrl());
        map.put("ssoLogoutUrl", this.ssoConfig.getSsoLogoutUrl());
        return ResponseEntity.ok(map);
    }

    @RequestMapping(value={"/refresh"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5237\u65b0token", httpMethod="GET", notes="\u5237\u65b0token")
    public ResponseEntity<?> refreshAndGetAuthenticationToken(HttpServletRequest request) {
        String authToken = request.getHeader(this.jwtConfig.getHeader());
        String token = authToken.substring(7);
        String tenantId = this.jwtTokenHandler.getTenantIdFromToken(token);
        String account = this.jwtTokenHandler.getUsernameFromToken(token);
        String refreshedToken = this.jwtTokenHandler.refreshToken(token);
        boolean isMobile = HttpUtil.isMobile(request);
        this.handleSingleLogin(isMobile, tenantId, account, refreshedToken);
        return ResponseEntity.ok((Object)new JwtAuthenticationResponse(refreshedToken, "", "", ""));
    }

    @RequestMapping(value={"/signout"}, method={RequestMethod.GET})
    @ApiOperation(value="\u9000\u51fa\u767b\u5f55", httpMethod="GET", notes="\u4f7ftoken\u7684\u72b6\u6001\u5931\u6548,\u5fc5\u987b\u8bbe\u7f6ejwt.single\u548cjwt.stricky\u5747\u4e3atrue")
    public CommonResult<String> signout(HttpServletRequest request) {
        String authToken = request.getHeader(this.jwtConfig.getHeader());
        String token = authToken.substring(7);
        String tenantId = this.jwtTokenHandler.getTenantIdFromToken(token);
        String account = this.jwtTokenHandler.getUsernameFromToken(token);
        boolean isMobile = HttpUtil.isMobile(request);
        this.handleLogout(isMobile, tenantId, account);
        return new CommonResult<String>("\u9000\u51fa\u6210\u529f");
    }

    private void authenticate(String username, String password) throws AuthenticationException, CertificateException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    private boolean checkUser(IUser user, String password) {
        if (!user.isAdmin()) {
            PwdStrategyService service = AppUtil.getBean(PwdStrategyService.class);
            if (service == null) {
                return true;
            }
            JsonNode json = service.getJsonDefault();
            if (BeanUtils.isNotEmpty(json)) {
                String initPwd = json.get("initPwd").asText();
                int pwdRule = json.get("pwdRule").asInt();
                int pwdLength = json.get("pwdLength").asInt();
                int duration = json.get("duration").asInt();
                long autoUnlockTime = json.get("autoUnlockTime").asLong();
                int initUpdate = json.get("initUpdate").asInt();
                int enable = json.get("enable").asInt();
                if (2 == user.getLockedStatus()) {
                    LocalDateTime lockedTime = user.getLockedTime();
                    Long intervalMinutes = (LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli() - lockedTime.toInstant(ZoneOffset.of("+8")).toEpochMilli()) / 60000L;
                    if (intervalMinutes >= autoUnlockTime) {
                        this.loginUserService.lockedUser(user.getAccount(), 1);
                    } else {
                        long sy = autoUnlockTime - intervalMinutes;
                        throw new RuntimeException("\u8d26\u53f7\u5728\u9501\u5b9a\u72b6\u6001\u4e2d,\u8bf7\u4e8e\u3010" + sy + "\u5206\u949f\u3011\u540e\u767b\u5f55\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u9501\uff01");
                    }
                }
                if (enable == 1) {
                    LocalDateTime currenTime;
                    int size;
                    String regex;
                    boolean result;
                    if (password.equals(initPwd)) {
                        return false;
                    }
                    if (password.length() < pwdLength) {
                        return false;
                    }
                    if (pwdRule != 1 && (pwdRule == 2 ? !(result = password.matches(regex = "^(?![a-zA-z]+$)(?!\\d+$)(?![!@#$%^&*]+$)[a-zA-Z\\d!@#$%^&*]+$")) : (pwdRule == 3 ? !(result = password.matches(regex = "^(?=.*?[A-Za-z])(?=.*?\\d)(?=.*?[~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/])[a-zA-Z\\d~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/]*$")) : pwdRule == 4 && !(result = password.matches(regex = "^(?=.*?[a-z])(?=.*?[A-Z])(?=.*?\\d)(?=.*?[~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/])[a-zA-Z\\d~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/]*$"))))) {
                        return false;
                    }
                    if (initUpdate == 1 && null == user.getLastLoginTime()) {
                        return false;
                    }
                    LocalDateTime pwdCreateTime = user.getPwdCreateTime();
                    if (BeanUtils.isNotEmpty(pwdCreateTime) && (size = (int)((currenTime = LocalDateTime.now()).toLocalDate().toEpochDay() - pwdCreateTime.toLocalDate().toEpochDay())) > duration) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void handleSingleLogin(boolean isMobile, String tenantId, String username, String token) {
        String userAgent;
        String string = userAgent = isMobile ? "mobile" : "pc";
        if (this.jwtConfig.isSingle()) {
            if (StringUtil.isEmpty(tenantId) && !this.saasConfig.isEnable()) {
                tenantId = "-1";
            }
            this.jwtTokenHandler.putTokenInCache(userAgent, tenantId, username, this.jwtConfig.getExpiration(), token);
        } else {
            HttpServletRequest request = HttpUtil.getRequest();
            String IP = IPUtils.getIpAddr(request);
            this.jwtTokenHandler.putTokenInCache(userAgent, tenantId, username, IP, this.jwtConfig.getExpiration(), token);
        }
        this.loginLogService.log(username, isMobile ? "mobile" : "pc");
    }

    private void handleLogout(boolean isMobile, String tenantId, String account) {
        if (this.jwtConfig.isSingle()) {
            String userAgent;
            String string = userAgent = isMobile ? "mobile" : "pc";
            if (StringUtil.isEmpty(tenantId) && !this.saasConfig.isEnable()) {
                tenantId = "-1";
            }
            this.jwtTokenHandler.removeFromCache(userAgent, tenantId, account);
        }
    }
}

