/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.duty.manager.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.dao.CmgtDutyTeamDao;
import com.artfess.manage.duty.dao.CmgtDutyTeamMemberDao;
import com.artfess.manage.duty.dao.CmgtDutyTeamMemberGpsinfoDao;
import com.artfess.manage.duty.dao.CmgtDutyWorkarrangeDao;
import com.artfess.manage.duty.dao.CmgtDutyWorkclassDao;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeMemberManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamMemberDto;
import com.artfess.manage.duty.manager.dto.CmgtDutyWorkarrangeDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyTeamMemberDtoMapper;
import com.artfess.manage.duty.manager.mapper.CmgtDutyWorkarrangeDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyJob;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import com.artfess.manage.duty.model.CmgtDutyTeamMemberGpsinfo;
import com.artfess.manage.duty.model.CmgtDutyWorkarrange;
import com.artfess.manage.duty.model.CmgtDutyWorkarrangeMember;
import com.artfess.manage.duty.model.CmgtDutyWorkclass;
import com.artfess.manage.duty.model.TeamMemberStatusEnum;
import com.artfess.manage.duty.vo.ExcelArrangeVo;
import com.artfess.manage.duty.vo.WorkArrangeInfoVo;
import com.artfess.manage.duty.vo.WorkArrangeMemberVo;
import com.artfess.manage.duty.vo.WorkarrangeVo;
import com.artfess.manage.utils.ExcelUtils;
import com.artfess.manage.utils.GeoUtils;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.exception.BadRequestException;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmgtDutyWorkarrangeManagerImpl
extends BaseManagerImpl<CmgtDutyWorkarrangeDao, CmgtDutyWorkarrange>
implements CmgtDutyWorkarrangeManager {
    @Resource
    private CmgtDutyWorkarrangeDao cmgtDutyWorkarrangeDao;
    @Resource
    CmgtDutyWorkarrangeMemberManager memberManager;
    @Resource
    CmgtDutyWorkarrangeDtoMapper cmgtDutyWorkarrangeDtoMapper;
    @Resource
    private CmgtDutyWorkclassDao cmgtDutyWorkclassDao;
    @Resource
    private CmgtDutyTeamDao cmgtDutyTeamDao;
    @Resource
    private CmgtDutyTeamMemberDao cmgtDutyTeamMemberDao;
    @Resource
    private CmgtDutyTeamMemberDtoMapper cmgtDutyTeamMemberDtoMapper;
    @Resource
    private CmgtDutyJobDao cmgtDutyJobDao;
    @Resource
    private CmgtDutyTeamMemberGpsinfoDao cmgtDutyTeamMemberGpsinfoDao;
    @Resource
    private OrgDao orgDao;
    static String[] MEMBER_STATUS = new String[]{"NORMAL", "ONLINE", "CROSSING", "ABSENT"};

    @Override
    public PageList<CmgtDutyWorkarrange> pageQuery(QueryFilter<CmgtDutyWorkarrange> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<CmgtDutyWorkarrange> result = ((CmgtDutyWorkarrangeDao)this.baseMapper).queryPage((IPage<CmgtDutyWorkarrange>)this.convert2IPage(pageBean), (Wrapper<CmgtDutyWorkarrange>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public List<WorkArrangeInfoVo> findAllByMonth(String date, String orgId) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtil.isEmpty((String)date)) {
            date = format.format(new Date());
        }
        String startDate = com.artfess.manage.utils.DateUtil.getMinMonthDate(date);
        String endDate = com.artfess.manage.utils.DateUtil.getMaxMonthDate(date);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("orgId", orgId);
        return this.cmgtDutyWorkarrangeDao.findAllByMonth(params);
    }

    @Override
    public List<CmgtDutyWorkarrangeDto> findTeamMemberArrangeing(String date, String teamMemberId) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtil.isEmpty((String)date)) {
            date = format.format(new Date());
        }
        String startDate = com.artfess.manage.utils.DateUtil.getMinMonthDate(date);
        String endDate = com.artfess.manage.utils.DateUtil.getMaxMonthDate(date);
        return this.findTeamMemberArrangeing(startDate, endDate, teamMemberId);
    }

    @Override
    public List<CmgtDutyWorkarrangeDto> findTeamMemberArrangeing(String startDate, String endDate, String teamMemberId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.between((Object)"arrange_date_", (Object)startDate, (Object)endDate);
        queryWrapper.like((Object)"teammember_id_", (Object)teamMemberId);
        return this.cmgtDutyWorkarrangeDao.selectList((Wrapper)queryWrapper).stream().map(r -> {
            CmgtDutyWorkarrangeDto t = (CmgtDutyWorkarrangeDto)((Object)((Object)this.cmgtDutyWorkarrangeDtoMapper.toDto(r)));
            t.setCmgtDutyWorkclass((CmgtDutyWorkclass)((Object)((Object)this.cmgtDutyWorkclassDao.selectById((Serializable)((Object)r.getWorkclassId())))));
            t.setCmgtDutyTeam((CmgtDutyTeam)((Object)((Object)this.cmgtDutyTeamDao.selectById((Serializable)((Object)r.getTeamId())))));
            return t;
        }).collect(Collectors.toList());
    }

    public List<CmgtDutyWorkarrange> findBy(LocalDate arrangeDate, String workclassId, String orgId) {
        QueryFilter filter = QueryFilter.build();
        filter.addFilter("arrange_date_", (Object)arrangeDate, QueryOP.EQUAL);
        filter.addFilter("workclass_id_", (Object)workclassId, QueryOP.EQUAL);
        filter.addFilter("org_id_", (Object)orgId, QueryOP.EQUAL);
        return this.queryNoPage(filter);
    }

    @Override
    @Transactional(readOnly=false)
    public void saveInfo(CmgtDutyWorkarrangeDto t, boolean isAdd) {
        CmgtDutyWorkarrange cmgtDutyWorkarrange = (CmgtDutyWorkarrange)((Object)this.cmgtDutyWorkarrangeDtoMapper.toEntity(t));
        if (isAdd) {
            this.createInfo(cmgtDutyWorkarrange);
        } else {
            this.updateInfo(cmgtDutyWorkarrange);
        }
        if (t.getSelectDays() != null && t.getSelectDays().length > 0) {
            for (String day : t.getSelectDays()) {
                if (day.equals(cmgtDutyWorkarrange.getArrangeDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")))) continue;
                CmgtDutyWorkarrange workarrange = (CmgtDutyWorkarrange)((Object)this.cmgtDutyWorkarrangeDtoMapper.toEntity(t));
                workarrange.setId(null);
                workarrange.setCreateBy(null);
                workarrange.setCreateTime(null);
                workarrange.setCreateOrgId(null);
                workarrange.setArrangeDate(LocalDate.parse(day, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                if (t.getIsCover() != null && t.getIsCover().booleanValue()) {
                    List<CmgtDutyWorkarrange> workarrangeList = this.findBy(workarrange.getArrangeDate(), workarrange.getWorkclassId(), workarrange.getOrgId());
                    for (CmgtDutyWorkarrange w : workarrangeList) {
                        this.deleteInfo(w);
                    }
                }
                this.createInfo(workarrange);
            }
        }
    }

    @Override
    @Transactional(readOnly=false)
    public boolean createInfo(CmgtDutyWorkarrange t) {
        if (t.getTeammemberId() == null) {
            throw new BadRequestException("\u6392\u73ed\u672a\u6307\u5b9a\u961f\u5458");
        }
        if (this.findBy(t.getArrangeDate(), t.getWorkclassId(), t.getOrgId()).size() > 0) {
            throw new BadRequestException(t.getArrangeDate() + ",\u8be5\u73ed\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6392\u73ed");
        }
        t.setTeammemberNames(StringUtil.join((Collection)Arrays.asList(t.getTeammemberId().split(",")).stream().map(mid -> ((CmgtDutyTeamMember)((Object)((Object)this.cmgtDutyTeamMemberDao.selectById((Serializable)((Object)mid))))).getName()).collect(Collectors.toList()), (String)","));
        boolean res = this.save((Object)t);
        this.saveMember(t.getTeammemberId(), t);
        return res;
    }

    @Override
    @Transactional(readOnly=false)
    public String updateInfo(CmgtDutyWorkarrange t) {
        if (t.getTeammemberId() == null) {
            throw new BadRequestException("\u6392\u73ed\u672a\u6307\u5b9a\u961f\u5458");
        }
        t.setTeammemberNames(StringUtil.join((Collection)Arrays.asList(t.getTeammemberId().split(",")).stream().map(mid -> ((CmgtDutyTeamMember)((Object)((Object)this.cmgtDutyTeamMemberDao.selectById((Serializable)((Object)mid))))).getName()).collect(Collectors.toList()), (String)","));
        this.updateById((Object)t);
        this.delMember(t);
        this.saveMember(t.getTeammemberId(), t);
        return t.getId();
    }

    @Override
    @Transactional(readOnly=false)
    public void deleteInfo(CmgtDutyWorkarrange t) {
        ((CmgtDutyWorkarrangeDao)this.baseMapper).deleteById((Serializable)((Object)t.getId()));
        this.delMember(t);
    }

    @Override
    public boolean fastWorkarrange(Map<String, Object> params) throws ParseException {
        if (params == null) {
            return false;
        }
        if (params.get("orgId") == null || StringUtil.isEmpty((String)params.get("orgId").toString())) {
            return false;
        }
        if (params.get("date") == null || StringUtil.isEmpty((String)params.get("date").toString())) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String date = params.get("date").toString();
        String orgId = params.get("orgId").toString();
        String lastMonth = com.artfess.manage.utils.DateUtil.getPrevMonthDate(date, 1);
        System.out.println("---------getMaxMonthDate-------" + lastMonth);
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("startDate", com.artfess.manage.utils.DateUtil.getMinMonthDate(lastMonth + "-01"));
        para.put("endDate", com.artfess.manage.utils.DateUtil.getMaxMonthDate(lastMonth + "-01"));
        para.put("orgId", orgId);
        System.out.println("------------para----" + para);
        List<WorkArrangeInfoVo> lastArrangeList = this.cmgtDutyWorkarrangeDao.findAllByMonth(para);
        System.out.println(lastArrangeList.size() + "------------lastArrangeList----" + para);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(format.parse(date));
        int day = calendar.getActualMaximum(5);
        int i = 1;
        while (i <= day) {
            int y = i++;
            lastArrangeList.stream().forEach(a -> {
                String d = Integer.toString(y);
                if (y < 10) {
                    d = "0" + d;
                }
                if (a.getArrangeDate().substring(8, 10).equals(d)) {
                    CmgtDutyWorkarrange arr = new CmgtDutyWorkarrange();
                    LocalDate localDate = LocalDate.parse(date + "-" + d);
                    arr.setArrangeDate(localDate);
                    arr.setDataType(a.getDataType());
                    arr.setTeamId(a.getTid());
                    arr.setTeammemberId(a.getMids());
                    arr.setWorkclassId(a.getClassId());
                    arr.setIsDele("0");
                    arr.setStatus("1");
                    arr.setOrgId(orgId);
                    this.cmgtDutyWorkarrangeDao.insert((Object)arr);
                    this.saveMember(a.getMids(), arr);
                }
            });
        }
        return true;
    }

    public void saveMember(String mids, CmgtDutyWorkarrange arr) {
        String[] memberIds = mids.split(",");
        ArrayList<CmgtDutyWorkarrangeMember> list = new ArrayList<CmgtDutyWorkarrangeMember>();
        for (String mid : memberIds) {
            CmgtDutyWorkarrangeMember member = new CmgtDutyWorkarrangeMember();
            member.setMemberId(mid);
            member.setWorkarrangeId(arr.getId());
            list.add(member);
        }
        this.memberManager.saveBatch(list);
    }

    void delMember(CmgtDutyWorkarrange arr) {
        QueryFilter filter = QueryFilter.build();
        filter.addFilter("WORK_ARRANGE_", (Object)arr.getId(), QueryOP.EQUAL);
        List list = this.memberManager.queryNoPage(filter);
        List ids = list.stream().map(l -> l.getId()).collect(Collectors.toList());
        this.memberManager.removeByIds(ids);
    }

    @Override
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtil.isEmpty((String)date)) {
            date = format.format(new Date());
        }
        String startDate = com.artfess.manage.utils.DateUtil.getMinMonthDate(date);
        String endDate = com.artfess.manage.utils.DateUtil.getMaxMonthDate(date);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int day = calendar.getActualMaximum(5);
        ArrayList reslist = new ArrayList();
        for (int i = 1; i <= day; ++i) {
            HashSet teams = new HashSet();
            HashMap<String, Object> params = new HashMap<String, Object>();
            String arrangeDate = startDate.substring(0, 8) + i;
            params.put("arrangeDate", arrangeDate);
            List<WorkarrangeVo> vo = this.cmgtDutyWorkarrangeDao.findArrangeInfoByDay(params);
            vo.forEach(v -> {
                StringBuilder dy = new StringBuilder();
                StringBuilder dz = new StringBuilder();
                HashSet fzr = new HashSet();
                HashSet fzr2 = new HashSet();
                HashSet headman = new HashSet();
                v.getDetails().forEach(m -> {
                    if (m.getTeamname().equals("\u5185\u52e4\u7ec4") && m.getPost().equals("1")) {
                        fzr.add(m.getMembername() + "(" + m.getPhone() + ") ");
                    }
                    if (m.getTeamname().equals("\u7763\u5bdf\u4fdd\u969c\u7ec4") && m.getPost().equals("1")) {
                        fzr2.add(m.getMembername() + "(" + m.getPhone() + ") ");
                    }
                    if (m.getPost().equals("2")) {
                        dz.append(m.getMembername() + "(\u961f\u957f)" + m.getPhone() + " ");
                    }
                    if (m.getPost().equals("3")) {
                        dz.append(m.getMembername() + "(\u4e2d\u961f\u957f)" + m.getPhone() + " ");
                    }
                    if (m.getPost().equals("4")) {
                        dy.append(m.getMembername() + m.getPhone() + " ");
                    }
                    headman.add(m.getHeadman());
                });
                ExcelArrangeVo evo = new ExcelArrangeVo(arrangeDate, ((Object)headman).toString(), ((Object)fzr).toString(), ((Object)fzr2).toString(), v.getClassName() + "(" + v.getStartDate() + "-" + v.getEndDate() + ")", dz.toString(), dy.toString());
                reslist.add(evo);
            });
        }
        ExcelWriter writer = ExcelUtil.getWriter();
        writer.addHeaderAlias("date", "\u65e5\u671f");
        writer.addHeaderAlias("headman", "\u7ec4\u957f");
        writer.addHeaderAlias("fzr", "\u5185\u52e4\u7ec4");
        writer.addHeaderAlias("fzr2", "\u7763\u5bdf\u4fdd\u969c\u7ec4");
        writer.addHeaderAlias("classname", "\u73ed\u6b21");
        writer.addHeaderAlias("dz", "\u961f\u957f");
        writer.addHeaderAlias("dy", "\u961f\u5458");
        writer.merge(6, (Object)(startDate + "\u81f3" + endDate + "\u6392\u73ed\u8868"));
        writer.write(reslist, false);
        ExcelUtils.setSizeColumn(writer.getSheet(), 6);
        ExcelUtils.downloadExcel(response, startDate + "\u81f3" + endDate + "\u6392\u73ed\u8868", writer);
    }

    @Override
    public void exportMemberArrangeExcel(HttpServletRequest request, HttpServletResponse response, String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtil.isEmpty((String)date)) {
            date = format.format(new Date());
        }
        String startDate = com.artfess.manage.utils.DateUtil.getMinMonthDate(date);
        String endDate = com.artfess.manage.utils.DateUtil.getMaxMonthDate(date);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int day = calendar.getActualMaximum(5);
        String arrangeDate = startDate.substring(0, 8);
        ExcelWriter writer = ExcelUtil.getWriter();
        ArrayList<Object> days = new ArrayList<Object>();
        ArrayList<String> weeks = new ArrayList<String>();
        days.add("\u5e8f\u53f7");
        days.add("\u59d3\u540d \u65e5\u671f");
        weeks.add("");
        weeks.add("");
        writer.merge(day + 1, (Object)(arrangeDate + "\u4ea4\u5de1\u7ec4\u6392\u73ed\u8868"));
        writer.passCurrentRow();
        for (int i = 1; i <= day; ++i) {
            days.add(i);
            weeks.add(this.dayOfWeek(format.parse(arrangeDate + i)));
        }
        writer.writeRow(days);
        writer.writeRow(weeks);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        List<WorkArrangeMemberVo> mlist = this.cmgtDutyWorkarrangeDao.findMemberArrange(params);
        int rowNum = 1;
        for (WorkArrangeMemberVo m : mlist) {
            String[] col = new String[day + 2];
            col[0] = rowNum + "";
            col[1] = m.getName();
            m.getDetails().forEach(d -> {
                col[d.getDate().intValue() + 1] = "\u5168\u52e4";
            });
            writer.writeRow(Arrays.asList(col));
            ++rowNum;
        }
        writer.merge(1, 2, 0, 0, (Object)"\u5e8f\u53f7", false);
        writer.merge(1, 2, 1, 1, (Object)"\u59d3\u540d \u65e5\u671f", false);
        ExcelUtils.downloadExcel(response, startDate + "\u81f3" + endDate + "\u6392\u73ed\u8868", writer);
    }

    public String dayOfWeek(Date date) {
        int day = DateUtil.dayOfWeek((Date)date);
        switch (day) {
            case 1: {
                return "\u65e5";
            }
            case 2: {
                return "\u4e00";
            }
            case 3: {
                return "\u4e8c";
            }
            case 4: {
                return "\u4e09";
            }
            case 5: {
                return "\u56db";
            }
            case 6: {
                return "\u4e94";
            }
            case 7: {
                return "\u516d";
            }
        }
        return "";
    }

    @Override
    public List<CmgtDutyWorkarrangeDto> findCmgtDutyWorkarrangeDtosBy(String arrangeDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"arrange_date_", (Object)arrangeDate);
        return this.cmgtDutyWorkarrangeDtoMapper.toDto(this.cmgtDutyWorkarrangeDao.selectList((Wrapper)queryWrapper)).stream().map(t -> {
            if (t.getTeamId() != null) {
                t.setCmgtDutyTeam((CmgtDutyTeam)((Object)((Object)this.cmgtDutyTeamDao.selectById((Serializable)((Object)t.getTeamId())))));
            } else {
                t.setCmgtDutyTeam(new CmgtDutyTeam());
            }
            if (t.getOrgId() != null) {
                t.setOrg((Org)this.orgDao.selectById((Serializable)((Object)t.getOrgId())));
            } else {
                t.setOrg(new Org());
            }
            if (t.getWorkclassId() != null) {
                t.setCmgtDutyWorkclass((CmgtDutyWorkclass)((Object)((Object)this.cmgtDutyWorkclassDao.selectById((Serializable)((Object)t.getWorkclassId())))));
            } else {
                t.setCmgtDutyWorkclass(new CmgtDutyWorkclass());
            }
            t.setTeamMembers(Arrays.asList(t.getTeammemberId().split(",")).stream().map(mid -> {
                CmgtDutyTeamMemberDto memberDto = (CmgtDutyTeamMemberDto)((Object)((Object)((Object)this.cmgtDutyTeamMemberDtoMapper.toDto(this.cmgtDutyTeamMemberDao.selectById((Serializable)((Object)mid))))));
                memberDto.setOrg((Org)this.orgDao.selectById((Serializable)((Object)memberDto.getOrgId())));
                if (memberDto.getJob() != null) {
                    memberDto.setCmgtDutyJob((CmgtDutyJob)((Object)((Object)((Object)this.cmgtDutyJobDao.selectById((Serializable)((Object)memberDto.getJob()))))));
                }
                return memberDto;
            }).collect(Collectors.toList()));
            return t;
        }).collect(Collectors.toList());
    }

    @Override
    public List<CmgtDutyWorkarrangeDto> findCmgtDutyWorkarrangeDtosBy(String arrangeDate, LocalTime dutyTime) {
        List<CmgtDutyWorkarrangeDto> r = this.findCmgtDutyWorkarrangeDtosBy(arrangeDate);
        return r.stream().filter(e -> {
            if (dutyTime.compareTo(e.getCmgtDutyWorkclass().getScheduleStart()) == 1 && dutyTime.compareTo(e.getCmgtDutyWorkclass().getDuringTime()) == -1) {
                return true;
            }
            return e.getCmgtDutyWorkclass().getScheduleStart().compareTo(e.getCmgtDutyWorkclass().getDuringTime()) == 1 && dutyTime.compareTo(e.getCmgtDutyWorkclass().getScheduleStart()) == 1;
        }).collect(Collectors.toList());
    }

    @Override
    public JSONArray findCurrentStaffOnDuty(List<String> dutyJobIds) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
        JSONArray r = JSONUtil.createArray();
        ArrayList mIds = new ArrayList();
        this.findCmgtDutyWorkarrangeDtosBy(com.artfess.manage.utils.DateUtil.getNowTime(), LocalTime.now()).forEach(t -> {
            for (CmgtDutyTeamMemberDto member : t.getTeamMembers()) {
                if (dutyJobIds != null && !dutyJobIds.contains(member.getJob()) || mIds.contains(member.getId())) continue;
                r.add((Object)JSONUtil.createObj().putOpt("dutyDate", (Object)t.getArrangeDate()).putOpt("id", (Object)member.getId()).putOpt("job", (Object)member.getJob()).putOpt("jobName", (Object)(member.getCmgtDutyJob() != null ? member.getCmgtDutyJob().getName() : "")).putOpt("dutyStart", (Object)(t.getCmgtDutyWorkclass().getScheduleStart() != null ? t.getCmgtDutyWorkclass().getScheduleStart().format(dtf) : "")).putOpt("dutyEnd", (Object)(t.getCmgtDutyWorkclass().getDuringTime() != null ? t.getCmgtDutyWorkclass().getDuringTime().format(dtf) : "")).putOpt("name", (Object)member.getName()).putOpt("sex", (Object)member.getSex()).putOpt("post", (Object)member.getPost()).putOpt("phone", (Object)member.getPhone()).putOpt("org", (Object)member.getOrg().getName()).putOpt("team", (Object)t.getCmgtDutyTeam().getName()).putOpt("status", (Object)member.getStatus()).putOpt("statusName", (Object)TeamMemberStatusEnum.findByCode(member.getStatus())).putOpt("location", (Object)member.getLocation()).putOpt("receiveTime", (Object)member.getReceiveTime()));
                mIds.add(member.getId());
            }
        });
        return r;
    }

    @Override
    public JSONArray findHistoryDutyStaff(List<String> dutyJobIds, List<LocalDateTime> rqs, JSONObject params) {
        JSONArray r = JSONUtil.createArray();
        ArrayList mIds = new ArrayList();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
        LocalDateTime arrangeDate = rqs.get(1);
        this.findCmgtDutyWorkarrangeDtosBy(arrangeDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), arrangeDate.toLocalTime()).forEach(t -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        return r;
    }

    @Override
    @Transactional
    public void createSumilatedTeamMemberLoationData() {
        List<CmgtDutyWorkarrangeDto> l = this.findCmgtDutyWorkarrangeDtosBy(com.artfess.manage.utils.DateUtil.getNowTime(), LocalTime.now());
        CmgtDutyWorkarrangeDto t = l.get(RandomUtil.randomInt((int)0, (int)(l.size() - 1)));
        List members = this.cmgtDutyTeamMemberDtoMapper.toEntity(t.getTeamMembers());
        for (CmgtDutyTeamMemberDto memberDto : t.getTeamMembers()) {
            CmgtDutyTeamMember member = (CmgtDutyTeamMember)((Object)this.cmgtDutyTeamMemberDtoMapper.toEntity(memberDto));
            CmgtDutyTeamMemberGpsinfo gpsinfo = new CmgtDutyTeamMemberGpsinfo();
            gpsinfo.setTeamMemberId(member.getId());
            gpsinfo.setReceiveTime(LocalDateTime.now());
            gpsinfo.setMemo("\u968f\u673a\u751f\u6210\u6a21\u62df\u6570\u636e");
            if (member.getLocation() == null) {
                gpsinfo.setLongitude(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(106.537288), (BigDecimal)BigDecimal.valueOf(106.55633)) + "");
                gpsinfo.setLatitude(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(29.606626), (BigDecimal)BigDecimal.valueOf(29.615619)) + "");
            } else {
                BigDecimal lg = new BigDecimal(member.getLocation().split(",")[0]);
                BigDecimal la = new BigDecimal(member.getLocation().split(",")[1]);
                lg = lg.add(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(-9.0E-4), (BigDecimal)BigDecimal.valueOf(9.0E-4)));
                la = la.add(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(-9.0E-4), (BigDecimal)BigDecimal.valueOf(9.0E-4)));
                if (lg.doubleValue() > 106.55633 || lg.doubleValue() < 106.537288 || la.doubleValue() > 29.615619 || la.doubleValue() < 29.606626) {
                    gpsinfo.setLongitude(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(106.537288), (BigDecimal)BigDecimal.valueOf(106.55633)) + "");
                    gpsinfo.setLatitude(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(29.606626), (BigDecimal)BigDecimal.valueOf(29.615619)) + "");
                } else {
                    gpsinfo.setLongitude(lg + "");
                    gpsinfo.setLatitude(la + "");
                }
            }
            this.cmgtDutyTeamMemberGpsinfoDao.insert((Object)gpsinfo);
            member.setLocation(gpsinfo.getLongitude() + "," + gpsinfo.getLatitude());
            member.setReceiveTime(gpsinfo.getReceiveTime());
            if (memberDto.getCmgtDutyJob() != null && !GeoUtils.pointInPolygon(member.getLocation(), memberDto.getCmgtDutyJob().getArea())) {
                member.setStatus(TeamMemberStatusEnum.CROSSING.name());
            } else {
                member.setStatus(MEMBER_STATUS[RandomUtil.randomInt((int)0, (int)1)]);
            }
            this.cmgtDutyTeamMemberDao.updateById((Object)member);
        }
    }
}

