/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.alibaba.fastjson.JSON;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.dao.DeviceStatusLogDao;
import com.artfess.device.base.dao.DeviceVideoPointDao;
import com.artfess.device.base.dao.DeviceVideoPointExtendDao;
import com.artfess.device.base.dao.DeviceVideoZoneDao;
import com.artfess.device.base.manager.DeviceVideoPointManager;
import com.artfess.device.base.manager.DeviceVideoZoneManager;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.model.DeviceStatusLog;
import com.artfess.device.base.model.DeviceVideoPoint;
import com.artfess.device.base.model.DeviceVideoPointExtend;
import com.artfess.device.base.model.DeviceVideoZone;
import com.artfess.device.base.model.DeviceWarnInfo;
import com.artfess.device.base.utils.HttpUtil;
import com.artfess.device.base.vo.DeviceWarnInfoVo;
import com.artfess.redis.util.RedisUtil;
import com.artfess.rocketmq.producer.RocketMQProducer;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DeviceVideoPointManagerImpl
extends BaseManagerImpl<DeviceVideoPointDao, DeviceVideoPoint>
implements DeviceVideoPointManager {
    @Autowired
    private DeviceVideoZoneManager deviceVideoZoneManager;
    @Resource
    private DeviceVideoPointExtendDao videoPointExtendDao;
    @Resource
    DeviceStatusLogDao statusLogDao;
    @Resource
    private DeviceVideoZoneDao deviceVideoZoneDao;
    @Autowired
    private DeviceWarnInfoManager warnInfoManager;
    @Autowired
    private RocketMQProducer rocketMQUtils;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private RestTemplate restTemplate;
    final String ZGrootUri = "http://92.94.92.16:11125";

    @Override
    public void deleteZoneRes(String zoneCode) {
        ((DeviceVideoPointDao)this.baseMapper).deleteZoneRes(zoneCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateInfo(DeviceVideoPointExtend t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)t.getCode());
        this.videoPointExtendDao.delete((Wrapper)queryWrapper);
        this.videoPointExtendDao.insert((Object)t);
        return t.getId();
    }

    @Override
    public DeviceVideoPoint findByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)code);
        DeviceVideoPoint deviceVideoPoint = (DeviceVideoPoint)((Object)((DeviceVideoPointDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (null == deviceVideoPoint) {
            return new DeviceVideoPoint();
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"code_", (Object)code);
        DeviceVideoPointExtend deviceVideoPointExtend = (DeviceVideoPointExtend)((Object)this.videoPointExtendDao.selectOne((Wrapper)query));
        deviceVideoPoint.setDeviceVideoPointExtend(deviceVideoPointExtend);
        return deviceVideoPoint;
    }

    @Override
    @Transactional
    public Boolean updateVideoStatus(String deviceCode, String status) {
        HashMap<String, String> deviceStatus;
        Assert.hasText((String)deviceCode, (String)"\u8bbe\u5907\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)status, (String)"\u8bbe\u5907\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Integer result = null;
        QueryWrapper statusWrapper = new QueryWrapper();
        statusWrapper.eq((Object)"device_code_", (Object)deviceCode);
        statusWrapper.eq((Object)"end_time_", (Object)"9999-12-31 23:59:59");
        DeviceStatusLog deviceStatusLog = (DeviceStatusLog)((Object)this.statusLogDao.selectOne((Wrapper)statusWrapper));
        if (deviceStatusLog != null) {
            LocalDateTime times = LocalDateTime.now();
            if (!deviceStatusLog.getDeviceStatus().equals(status)) {
                Duration duration = Duration.between(deviceStatusLog.getStartTime(), times);
                deviceStatusLog.setTimeLength(duration.toMinutes());
                deviceStatusLog.setEndTime(times);
                deviceStatusLog.setLastTime(LocalDateTime.now());
                this.statusLogDao.updateById((Object)deviceStatusLog);
                DeviceStatusLog newDeviceStatusLog = new DeviceStatusLog();
                newDeviceStatusLog.setDeviceCode(deviceCode);
                newDeviceStatusLog.setDeviceStatus(status);
                newDeviceStatusLog.setDeviceType("5");
                newDeviceStatusLog.setStartTime(times);
                newDeviceStatusLog.setEndTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
                result = this.statusLogDao.insert((Object)newDeviceStatusLog);
            }
            deviceStatus = new HashMap<String, String>();
            deviceStatus.put("deviceCode", deviceCode);
            deviceStatus.put("proType", "5");
            deviceStatus.put("status", status);
            String deviceStatusString = JSON.toJSONString(deviceStatus);
            try {
                this.rocketMQUtils.send("sssb_device_status_message_topic", deviceStatusString);
            }
            catch (Exception e) {
                this.log.error("\u8bbe\u5907\u72b6\u6001\u53d1\u9001\u5931\u8d25:{}", (Throwable)e);
            }
        } else {
            DeviceStatusLog newDeviceStatusLog = new DeviceStatusLog();
            newDeviceStatusLog.setDeviceCode(deviceCode);
            newDeviceStatusLog.setDeviceStatus(status);
            newDeviceStatusLog.setDeviceType("5");
            newDeviceStatusLog.setStartTime(LocalDateTime.now());
            newDeviceStatusLog.setEndTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
            result = this.statusLogDao.insert((Object)newDeviceStatusLog);
            deviceStatus = new HashMap();
            deviceStatus.put("deviceCode", deviceCode);
            deviceStatus.put("proType", "5");
            deviceStatus.put("status", status);
            String deviceStatusString = JSON.toJSONString(deviceStatus);
            try {
                this.rocketMQUtils.send("sssb_device_status_message_topic", deviceStatusString);
            }
            catch (Exception e) {
                this.log.error("\u8bbe\u5907\u72b6\u6001\u53d1\u9001\u5931\u8d25:{}", (Throwable)e);
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)deviceCode);
        DeviceVideoPoint videoPoint = (DeviceVideoPoint)((Object)this.getOne((Wrapper)queryWrapper));
        if (videoPoint != null && !videoPoint.getStatus().equals(status)) {
            videoPoint.setStatus(status);
            videoPoint.setLastTime(LocalDateTime.now());
            this.updateById((Object)videoPoint);
        }
        return null != result && result >= 1;
    }

    @Override
    public String getZGVideoUri(String code, Integer module, boolean refresh) {
        Assert.hasText((String)code, (String)"\u89c6\u9891\u70b9\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)code);
        List list = ((DeviceVideoPointDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list == null || list.size() == 0) {
            throw new ApplicationException("\u6ca1\u6709\u67e5\u8be2\u5230\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u6444\u50cf\u5934\uff01");
        }
        DeviceVideoPoint deviceVideoPoint = (DeviceVideoPoint)((Object)list.get(0));
        if (!deviceVideoPoint.getPlatform().equals("ZG")) {
            throw new ApplicationException("\u6444\u50cf\u5934\u3010" + code + "\u3011\u4e0d\u662f\u7d2b\u5149\u534e\u667a\u7684\u6444\u50cf\u5934\uff01");
        }
        String token = this.getZGToken(false);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (module == null || module > 8 || module < 1) {
            module = 5;
        }
        param.put("channel_code", code);
        param.put("stream_mode", module);
        param.put("stream_type", 0);
        param.put("keep_alive", 600);
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("Authorization", token);
        try {
            String uri = "http://92.94.92.16:11125/api/vms/v2/webuas/live/stream/url";
            String result = HttpUtil.get(uri, param, head, null, 0, 0, null);
            if (result == null) {
                throw new ApplicationException("\u83b7\u53d6\u6d77\u5eb7\u76d1\u63a7\u70b9\u5931\u8d25!");
            }
            JsonNode root = JsonUtil.toJsonNode((String)result);
            if (root.has("error_code") && root.get("error_code").asText().indexOf("expired_accessToken") != -1) {
                this.getZGVideoUri(code, module, true);
            }
            if (root.has("data")) {
                return root.get("data").asText();
            }
            throw new ApplicationException("\u6ca1\u6709\u67e5\u8be2\u5230\u89c6\u9891\u6d41\u64ad\u653e\u5730\u5740\uff01");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer asycZGVideoPoint(boolean refresh) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"platform_", (Object)"ZG");
        ((DeviceVideoPointDao)this.baseMapper).delete((Wrapper)queryWrapper);
        QueryWrapper zoneWrapper = new QueryWrapper();
        zoneWrapper.eq((Object)"platform_", (Object)"ZG");
        this.deviceVideoZoneDao.delete((Wrapper)zoneWrapper);
        this.asycZGZone(refresh);
        List<DeviceVideoPoint> pointList = this.asycZGcameras(refresh);
        this.saveBatch(pointList);
        return pointList.size();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void asycZGZone(boolean refresh) {
        String token = this.getZGToken(refresh);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("org_index", "500199");
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("Authorization", token);
        ArrayList list = Lists.newArrayList();
        try {
            String uri = "http://92.94.92.16:11125/api/bss/v1/uuv/users/privilege/device-org/tree";
            String result = HttpUtil.get(uri, param, head, null, 0, 0, null);
            if (result == null) {
                throw new ApplicationException("\u83b7\u53d6\u7d2b\u5149\u534e\u667a\u76d1\u63a7\u70b9\u5931\u8d25!");
            }
            JsonNode root = JsonUtil.toJsonNode((String)result);
            if (root.has("error_code") && root.get("error_code").asText().indexOf("expired_accessToken") != -1) {
                this.asycZGZone(true);
            }
            if (root.has("data") && root.get("data") != null && !root.get("data").asText().equals("null")) {
                this.saveZGZone(root.get("data"));
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveZGZone(JsonNode data) {
        if (data != null) {
            ArrayNode dataList = (ArrayNode)data;
            ArrayList childNodes = Lists.newArrayList();
            for (JsonNode vnode : dataList) {
                DeviceVideoZone res = new DeviceVideoZone();
                res.setBaseCode("zg001");
                res.setPlatform("ZG");
                res.setCode(vnode.get("org_index").asText());
                res.setName(vnode.get("org_name").asText());
                if (vnode.get("org_parent_index").asText().equals("5001")) {
                    res.setParentId("-1");
                } else {
                    res.setParentId(vnode.get("org_parent_index").asText());
                }
                res.setId(vnode.get("org_index").asText());
                res.setCreateTime(LocalDateTime.now());
                res.setUpdateTime(LocalDateTime.now());
                res.setLastTime(LocalDateTime.now());
                this.deviceVideoZoneManager.saveTreeAndId(res);
                if (!vnode.has("child") || vnode.get("child") == null || vnode.get("child").asText().equals("null")) continue;
                childNodes.add(vnode.get("child"));
            }
            if (childNodes != null && childNodes.size() > 0) {
                for (JsonNode childNode : childNodes) {
                    this.saveZGZone(childNode);
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<DeviceVideoPoint> asycZGcameras(boolean refresh) {
        ArrayList list;
        block19: {
            String token = this.getZGToken(refresh);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("sub_type", 1);
            param.put("resource_type", 6);
            param.put("order_field", "ape_id");
            param.put("order_rule", "asc");
            param.put("page_num", 1);
            param.put("page_size", 26000);
            param.put("org_index", 500199);
            HashMap<String, String> head = new HashMap<String, String>();
            head.put("Authorization", token);
            list = Lists.newArrayList();
            try {
                String result = HttpUtil.get("http://92.94.92.16:11125/api/bss/v1/udm/channel/list-with-device", param, head, null, 0, 0, null);
                if (result == null) {
                    throw new ApplicationException("\u83b7\u53d6\u6d77\u5eb7\u76d1\u63a7\u70b9\u5931\u8d25!");
                }
                JsonNode root = JsonUtil.toJsonNode((String)result);
                if (root.has("error_code") && root.get("error_code").asText().indexOf("expired_accessToken") != -1) {
                    this.asycZGcameras(true);
                }
                if (root.has("data") && root.get("data") != null) {
                    if (root.get("data").has("data")) {
                        ArrayList<DeviceWarnInfo> warnInfoList = new ArrayList<DeviceWarnInfo>();
                        ArrayNode dataList = (ArrayNode)root.get("data").get("data");
                        for (JsonNode vnode : dataList) {
                            DeviceVideoPoint res = new DeviceVideoPoint();
                            res.setCatalogCode("zg001");
                            res.setZoneCode(vnode.get("org_index").asText());
                            res.setCode(vnode.get("ape_id").asText());
                            res.setPlatform("ZG");
                            res.setAisle(vnode.get("idx").asText());
                            res.setName(vnode.get("name").asText());
                            if (vnode.get("longitude") != null) {
                                res.setLgtd(vnode.get("longitude").asText());
                            }
                            if (vnode.get("latitude") != null) {
                                res.setLttd(vnode.get("latitude").asText());
                            }
                            if (vnode.get("ip_addr") != null) {
                                res.setIp(vnode.get("ip_addr").asText());
                            }
                            res.setAddress(vnode.get("name").asText());
                            if (vnode.get("is_online").asText().equals("1")) {
                                res.setStatus("1");
                            } else {
                                res.setStatus("0");
                            }
                            res.setId(vnode.get("ape_id").asText());
                            res.setCreateTime(LocalDateTime.now());
                            res.setLastTime(LocalDateTime.now());
                            res.setUpdateTime(LocalDateTime.now());
                            list.add(res);
                            String code = vnode.get("ape_id").asText();
                            if (vnode.get("is_online") == null || !vnode.get("is_online").asText().equals("1")) {
                                this.updateVideoStatus(code, "2");
                                DeviceWarnInfo warnInfo = this.warnInfoManager.getNewWarnInfo(code, "1");
                                if (warnInfo == null || warnInfo != null && warnInfo.getHandleStatus() == 1) {
                                    DeviceVideoPointExtend videoPointExtend;
                                    warnInfo = new DeviceWarnInfo();
                                    warnInfo.setDeviceCode(code);
                                    warnInfo.setWarnName("\u89c6\u9891\u8bbe\u5907\u3010" + vnode.get("name").asText() + "\u3011\u79bb\u7ebf\u544a\u8b66\uff01");
                                    warnInfo.setWarnType("1");
                                    warnInfo.setDeviceType("5");
                                    warnInfo.setWarnReason("\u89c6\u9891\u8bbe\u5907\u3010" + vnode.get("name").asText() + "\u3011\u79bb\u7ebf\uff0c\u53ef\u80fd\u53d1\u751f\u6545\u969c\uff01");
                                    warnInfo.setWarnTime(res.getCreateTime());
                                    warnInfo.setCreateTime(LocalDateTime.now());
                                    warnInfo.setHandleStatus(0);
                                    warnInfoList.add(warnInfo);
                                    DeviceWarnInfoVo deviceWarnInfoVo = new DeviceWarnInfoVo();
                                    deviceWarnInfoVo.setDevName(vnode.get("name").asText());
                                    deviceWarnInfoVo.setDevCode(warnInfo.getDeviceCode());
                                    deviceWarnInfoVo.setEventSrcId(warnInfo.getId());
                                    deviceWarnInfoVo.setEventTitle(warnInfo.getWarnName());
                                    deviceWarnInfoVo.setEventTime(DateUtils.now());
                                    deviceWarnInfoVo.setEventSubClass(warnInfo.getDeviceType());
                                    deviceWarnInfoVo.setEventDesc(warnInfo.getWarnReason());
                                    deviceWarnInfoVo.setEventType(Integer.valueOf(warnInfo.getWarnType()));
                                    deviceWarnInfoVo.setEventAddr(vnode.get("name").asText());
                                    if (vnode.get("latitude") != null) {
                                        deviceWarnInfoVo.setEventLat(new BigDecimal(vnode.get("latitude").asDouble()));
                                    }
                                    if (vnode.get("longitude") != null) {
                                        deviceWarnInfoVo.setEventLng(new BigDecimal(vnode.get("longitude").asDouble()));
                                    }
                                    if ((videoPointExtend = this.videoPointExtendDao.findVideoExtendByCode(warnInfo.getDeviceCode())) != null) {
                                        deviceWarnInfoVo.setRegionCode(videoPointExtend.getAreaCode());
                                        deviceWarnInfoVo.setRegionName(videoPointExtend.getAreaName());
                                    }
                                    String warnInfoString = JSON.toJSONString((Object)deviceWarnInfoVo);
                                    try {
                                        this.rocketMQUtils.send("sssb_device_warn_message_topic", warnInfoString);
                                    }
                                    catch (Exception e) {
                                        this.log.error("\u53d1\u9001\u5931\u8d25:{}", (Throwable)e);
                                    }
                                }
                            }
                            if (!vnode.get("is_online").asText().equals("1")) continue;
                            this.updateVideoStatus(code, "1");
                        }
                        break block19;
                    }
                    this.log.error("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff01");
                    break block19;
                }
                this.log.error("\u6ca1\u6709\u8fd4\u56de\u6570\u636e\uff01");
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public String getZGToken(boolean refresh) {
        String token = "";
        if (!refresh) {
            token = (String)this.redisUtil.get("biz:zg:token", String.class);
        }
        if (StringUtil.isEmpty((String)token)) {
            HttpHeaders headers = new HttpHeaders();
            HttpMethod method = HttpMethod.POST;
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            String url = "http://92.94.92.16:11125/sso/oauth2.0/accessToken?grant_type=client_credentials&client_id=user003&client_secret=user003&format=json";
            try {
                ResponseEntity result = this.restTemplate.exchange(url, method, requestEntity, String.class, new Object[0]);
                JsonNode root = JsonUtil.toJsonNode((String)((String)result.getBody()));
                token = root.get("access_token").asText();
                Integer times = root.get("expires_in").asInt();
                if (times == null || times == 0) {
                    times = 6000;
                }
                this.redisUtil.set("biz:zg:token", (Object)token, (long)times.intValue());
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return token;
    }
}

