/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.alibaba.fastjson.JSON;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.device.base.dao.DeviceInfoDao;
import com.artfess.device.base.dao.DeviceVideoPointDao;
import com.artfess.device.base.dao.DeviceWarnInfoDao;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceWarnInfo;
import com.artfess.device.base.utils.BizUtils;
import com.artfess.device.base.vo.DeviceWarnInfoVo;
import com.artfess.device.base.vo.StatisticsVo;
import com.artfess.device.base.vo.VideoPointVo;
import com.artfess.rocketmq.producer.RocketMQProducer;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class DeviceWarnInfoManagerImpl
extends BaseManagerImpl<DeviceWarnInfoDao, DeviceWarnInfo>
implements DeviceWarnInfoManager {
    @Resource
    private SysDictionaryManager sdm;
    @Resource
    private DeviceInfoDao deviceInfoDao;
    @Resource
    private DeviceVideoPointDao deviceVideoPointDao;
    @Autowired
    private RocketMQProducer rocketMQUtils;

    public PageList<DeviceWarnInfo> query(QueryFilter<DeviceWarnInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        QueryWrapper wrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        IPage<DeviceWarnInfo> result = ((DeviceWarnInfoDao)this.baseMapper).queryPage((IPage<DeviceWarnInfo>)this.convert2IPage(pageBean), (QueryWrapper<DeviceWarnInfo>)wrapper);
        return new PageList(result);
    }

    @Override
    public Integer findByDeviceType(String deviceType) {
        return ((DeviceWarnInfoDao)this.baseMapper).findByDeviceType(deviceType);
    }

    @Override
    public DeviceWarnInfo getNewWarnInfo(String deviceCode, String warnType) {
        Assert.hasText((String)deviceCode, (String)"\u8bbe\u5907\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<DeviceWarnInfo> list = ((DeviceWarnInfoDao)this.baseMapper).getNewWarnInfo(deviceCode, warnType);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void sendWarnInfoToEventCenter(DeviceWarnInfo warnInfo) {
        DeviceWarnInfoVo deviceWarnInfoVo = new DeviceWarnInfoVo();
        deviceWarnInfoVo.setDevCode(warnInfo.getDeviceCode());
        deviceWarnInfoVo.setEventSrcId(warnInfo.getId());
        deviceWarnInfoVo.setEventTitle(warnInfo.getWarnName());
        deviceWarnInfoVo.setEventTime(DateUtils.now());
        deviceWarnInfoVo.setEventSubClass(warnInfo.getDeviceType());
        deviceWarnInfoVo.setEventDesc(warnInfo.getWarnReason());
        deviceWarnInfoVo.setEventType(Integer.valueOf(warnInfo.getWarnType()));
        if (warnInfo.getDeviceType().equals("5")) {
            List<VideoPointVo> videoPointVoList = this.deviceVideoPointDao.findByVideoCode(warnInfo.getDeviceCode());
            VideoPointVo videoPointVo = videoPointVoList.get(0);
            deviceWarnInfoVo.setRegionCode(videoPointVo.getAreaCode());
            deviceWarnInfoVo.setRegionName(videoPointVo.getAreaName());
            deviceWarnInfoVo.setEventAddr(videoPointVo.getAddress());
            deviceWarnInfoVo.setDevName(videoPointVo.getName());
            if (!StringUtils.isEmpty((Object)videoPointVo.getLttd())) {
                deviceWarnInfoVo.setEventLat(new BigDecimal(videoPointVo.getLttd()));
            }
            if (!StringUtils.isEmpty((Object)videoPointVo.getLgtd())) {
                deviceWarnInfoVo.setEventLng(new BigDecimal(videoPointVo.getLgtd()));
            }
        } else {
            DeviceInfo deviceInfo = this.deviceInfoDao.findByDeviceCode(warnInfo.getDeviceCode());
            deviceWarnInfoVo.setRegionCode(deviceInfo.getAreaCode());
            deviceWarnInfoVo.setRegionName(deviceInfo.getAreaName());
            deviceWarnInfoVo.setEventAddr(deviceInfo.getAddress());
            deviceWarnInfoVo.setDevName(deviceInfo.getName());
            if (!StringUtils.isEmpty((Object)deviceInfo.getLttd())) {
                deviceWarnInfoVo.setEventLat(new BigDecimal(deviceInfo.getLttd()));
            }
            if (!StringUtils.isEmpty((Object)deviceInfo.getLgtd())) {
                deviceWarnInfoVo.setEventLng(new BigDecimal(deviceInfo.getLgtd()));
            }
        }
        String warnInfoString = JSON.toJSONString((Object)deviceWarnInfoVo);
        try {
            this.rocketMQUtils.send("sssb_device_warn_message_topic", warnInfoString);
        }
        catch (Exception e) {
            this.log.error("\u53d1\u9001\u5931\u8d25:{}", (Throwable)e);
        }
    }

    @Override
    public List<StatisticsVo> statisticsWarn(StatisticsDto dto) {
        List rqlx = this.sdm.queryDictListItemsByCode("rqlx");
        List handleStatus = this.sdm.queryDictListItemsByCode("clzt");
        boolean isYear = "true".equals(dto.getIsYear());
        String inputType = dto.getDateType();
        dto.setDateType(BizUtils.getDicValueByCode(rqlx, dto.getDateType()));
        if (StringUtil.isEmpty((String)dto.getDateType())) {
            dto.setDateType("%Y-%m-%d");
        }
        List<Object> result = Lists.newArrayList();
        if (isYear) {
            Map<String, Map<String, List<StatisticsVo>>> data = ((DeviceWarnInfoDao)this.baseMapper).statisticsWarn(dto).stream().collect(Collectors.groupingBy(StatisticsVo::getType, Collectors.groupingBy(StatisticsVo::getStatus)));
            for (Map.Entry<String, Map<String, List<StatisticsVo>>> d : data.entrySet()) {
                StatisticsVo rTemp = new StatisticsVo();
                rTemp.setType(d.getKey());
                int totalCount = 0;
                ArrayList rtData = Lists.newArrayList();
                for (Map.Entry<String, List<StatisticsVo>> s : d.getValue().entrySet()) {
                    totalCount += s.getValue().size();
                    String status = BizUtils.getDicValueByCode(handleStatus, s.getKey());
                    rtData.add(new StatisticsVo(status, s.getValue().size()));
                }
                rtData.add(new StatisticsVo("\u603b\u6570", totalCount));
                rTemp.setData(rtData);
                result.add(rTemp);
            }
        } else {
            Map<String, Map<String, List<StatisticsVo>>> data = ((DeviceWarnInfoDao)this.baseMapper).statisticsWarn(dto).stream().collect(Collectors.groupingBy(StatisticsVo::getTime, Collectors.groupingBy(StatisticsVo::getStatus)));
            for (Map.Entry<String, Map<String, List<StatisticsVo>>> d : data.entrySet()) {
                StatisticsVo rTemp = new StatisticsVo();
                rTemp.setTime(d.getKey());
                int totalCount = 0;
                ArrayList<StatisticsVo> rtData = new ArrayList<StatisticsVo>();
                for (Map.Entry<String, List<StatisticsVo>> t : d.getValue().entrySet()) {
                    totalCount += t.getValue().size();
                    String status = BizUtils.getDicValueByCode(handleStatus, t.getKey());
                    StatisticsVo rtdTemp = new StatisticsVo(status, t.getValue().size());
                    rtData.add(rtdTemp);
                }
                rtData.add(new StatisticsVo("\u603b\u6570", totalCount));
                rTemp.setData(rtData);
                result.add(rTemp);
            }
            List<Object> emptyResult = new ArrayList();
            if ("1".equals(inputType)) {
                emptyResult = BizUtils.handleEmptyResult(12, dto.getTime(), (List<StatisticsVo>)result);
            }
            if ("2".equals(inputType)) {
                String[] inputTime = dto.getTime().split("-");
                Integer endTime = DateUtil.getDaysOfMonth((int)Integer.parseInt(inputTime[0]), (int)Integer.parseInt(inputTime[1]));
                emptyResult = BizUtils.handleEmptyResult(endTime, dto.getTime(), (List<StatisticsVo>)result);
            }
            result.addAll(emptyResult);
            result = result.stream().sorted(Comparator.comparing(StatisticsVo::getTime)).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<StatisticsVo> statisticsWarnSub(StatisticsDto dto) {
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)dto.getDateType(), (String)"\u65e5\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)dto.getTime(), (String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List rqlx = this.sdm.queryDictListItemsByCode("rqlx");
        dto.setDateType(BizUtils.getDicValueByCode(rqlx, dto.getDateType()));
        if (StringUtil.isEmpty((String)dto.getDateType())) {
            throw new RuntimeException("\u672a\u5b9a\u4e49\u7684\u65e5\u671f\u7c7b\u578b\uff01");
        }
        return ((DeviceWarnInfoDao)this.baseMapper).statisticsWarnSub(dto);
    }

    @Override
    public List<StatisticsVo> warnCountMonthly() {
        return ((DeviceWarnInfoDao)this.baseMapper).warnCountMonthly();
    }

    @Override
    public List<StatisticsVo> warnCountCurrently() {
        return ((DeviceWarnInfoDao)this.baseMapper).warnCountCurrently();
    }
}

