/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceInfoDao;
import com.artfess.device.base.dao.DeviceParamsValueDao;
import com.artfess.device.base.dao.DeviceProductInfoDao;
import com.artfess.device.base.dao.DeviceRelationContractDao;
import com.artfess.device.base.manager.DeviceInfoManager;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceParamsValue;
import com.artfess.device.base.model.DeviceProductInfo;
import com.artfess.device.base.model.DeviceRelationContract;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DeviceInfoManagerImpl
extends BaseManagerImpl<DeviceInfoDao, DeviceInfo>
implements DeviceInfoManager {
    @Resource
    private DeviceProductInfoDao deviceProductInfoDao;
    @Resource
    private DeviceRelationContractDao deviceRelationContractDao;
    @Resource
    private DeviceParamsValueDao paramsValueDao;

    @Override
    public List<DeviceInfo> findAll(DeviceInfo entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)entity.getCode())) {
            queryWrapper.like((Object)"code_", (Object)entity.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
            queryWrapper.like((Object)"name_", (Object)entity.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getStatus())) {
            queryWrapper.eq((Object)"status_", (Object)entity.getStatus());
        }
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        return ((DeviceInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public String createInfo(DeviceInfo t) {
        int insert = ((DeviceInfoDao)this.baseMapper).insert((Object)t);
        if (insert > 0) {
            DeviceProductInfo productInfo;
            List<DeviceRelationContract> contractList = t.getContractList();
            if (!CollectionUtils.isEmpty(contractList)) {
                contractList.forEach(contract -> {
                    contract.setDeviceId(t.getId());
                    this.deviceRelationContractDao.insert(contract);
                });
            }
            if (null != (productInfo = (DeviceProductInfo)((Object)this.deviceProductInfoDao.selectById((Serializable)((Object)t.getProductId()))))) {
                t.setFullName(productInfo.getFullName() + "/" + t.getFullName());
            }
            ((DeviceInfoDao)this.baseMapper).updateById((Object)t);
            this.processParamsValue(t.getParamsValueList(), t.getId());
            return t.getId();
        }
        return null;
    }

    private void processParamsValue(List<DeviceParamsValue> paramsValueList, String deviceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"device_id_", (Object)deviceId);
        this.paramsValueDao.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(paramsValueList)) {
            return;
        }
        paramsValueList.forEach(value -> {
            value.setDeviceId(deviceId);
            this.paramsValueDao.insert(value);
        });
    }

    @Override
    @Transactional
    public String updateInfo(DeviceInfo t) {
        DeviceProductInfo productInfo = (DeviceProductInfo)((Object)this.deviceProductInfoDao.selectById((Serializable)((Object)t.getProductId())));
        if (null != productInfo) {
            t.setFullName(productInfo.getFullName() + "/" + t.getFullName());
        }
        ((DeviceInfoDao)this.baseMapper).updateById((Object)t);
        this.processParamsValue(t.getParamsValueList(), t.getId());
        return t.getId();
    }
}

