/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.scene;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.community.reactorql.term.TermType;
import org.jetlinks.community.reactorql.term.TermTypes;
import org.jetlinks.community.rule.engine.scene.term.TermColumn;
import org.jetlinks.core.metadata.DataType;
import org.springframework.util.StringUtils;

public class Variable {
    public static final String OPTION_PRODUCT_ID = "productId";
    @Schema(description="\u53d8\u91cfID")
    private String id;
    @Schema(description="\u53d8\u91cf\u540d")
    private String name;
    @Schema(description="\u53d8\u91cf\u5168\u540d")
    private String fullName;
    @Schema(description="\u5217")
    private String column;
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Schema(description="\u7c7b\u578b")
    private String type;
    @Schema(description="\u652f\u6301\u7684\u6761\u4ef6\u7c7b\u578b")
    private List<TermType> termTypes;
    @Schema(description="\u5b50\u7ea7\u53d8\u91cf")
    private List<Variable> children;
    @Schema(description="\u662f\u5426\u4e3a\u7269\u6a21\u578b\u53d8\u91cf")
    private boolean metadata;
    @Schema(description="\u5176\u4ed6\u914d\u7f6e")
    private Map<String, Object> options;

    public String getFullName() {
        return this.fullName == null ? this.name : this.fullName;
    }

    public Variable withDescription(String description) {
        this.description = description;
        return this;
    }

    public Variable withMetadata(boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    public synchronized Map<String, Object> safeOptions() {
        return this.options == null ? (this.options = new HashMap<String, Object>()) : this.options;
    }

    public Variable withOption(String key, Object value) {
        this.safeOptions().put(key, value);
        return this;
    }

    public Variable withOptions(Map<String, Object> options) {
        this.safeOptions().putAll(options);
        return this;
    }

    public Variable withType(String type) {
        this.type = type;
        return this;
    }

    public Variable withType(DataType type) {
        this.withType(type.getId()).withTermType(TermTypes.lookup((DataType)type));
        return this;
    }

    public Variable withTermType(List<TermType> termTypes) {
        this.termTypes = termTypes;
        return this;
    }

    public Variable withColumn(String column) {
        this.column = column;
        return this;
    }

    public String getColumn() {
        if (StringUtils.hasText((String)this.column)) {
            return this.column;
        }
        return this.id;
    }

    public Variable with(TermColumn column) {
        this.name = column.getName();
        this.column = column.getColumn();
        this.metadata = column.isMetadata();
        this.description = column.getDescription();
        this.fullName = column.getFullName();
        this.type = column.getDataType();
        this.termTypes = column.getTermTypes();
        return this;
    }

    public void refactorPrefix() {
        this.refactorPrefix(this);
    }

    public void refactorPrefix(Variable main) {
        if (CollectionUtils.isNotEmpty(this.children)) {
            for (Variable child : this.children) {
                if (!child.getId().startsWith(main.id + ".")) {
                    child.setId(main.id + "." + child.getId());
                }
                if (StringUtils.hasText((String)child.getFullName()) && StringUtils.hasText((String)main.getFullName())) {
                    child.setFullName(main.getFullName() + "/" + child.getFullName());
                }
                child.refactorPrefix(main);
            }
        }
    }

    private Variable(String id, String name) {
        this.id = id;
        this.name = name;
        this.description = name;
        this.type = "string";
    }

    public Variable() {
    }

    public static Variable of(String id, String name) {
        return new Variable(id, name);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public List<TermType> getTermTypes() {
        return this.termTypes;
    }

    public List<Variable> getChildren() {
        return this.children;
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTermTypes(List<TermType> termTypes) {
        this.termTypes = termTypes;
    }

    public void setChildren(List<Variable> children) {
        this.children = children;
    }

    public void setMetadata(boolean metadata) {
        this.metadata = metadata;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }
}

