/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.measurement;

import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetlinks.community.dashboard.DashboardDefinition;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.ObjectDefinition;
import org.jetlinks.community.dashboard.supports.StaticMeasurementProvider;
import org.jetlinks.community.micrometer.MeterRegistryManager;
import org.jetlinks.community.rule.engine.entity.AlarmHistoryInfo;
import org.jetlinks.community.rule.engine.measurement.AlarmDashboardDefinition;
import org.jetlinks.community.rule.engine.measurement.AlarmObjectDefinition;
import org.jetlinks.community.rule.engine.measurement.AlarmRecordRankMeasurement;
import org.jetlinks.community.rule.engine.measurement.AlarmRecordTrendMeasurement;
import org.jetlinks.community.rule.engine.measurement.AlarmTimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.utils.ConverterUtils;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class AlarmRecordMeasurementProvider
extends StaticMeasurementProvider {
    MeterRegistry registry;

    public AlarmRecordMeasurementProvider(MeterRegistryManager registryManager, TimeSeriesManager timeSeriesManager) {
        super((DashboardDefinition)AlarmDashboardDefinition.alarm, (ObjectDefinition)AlarmObjectDefinition.record);
        this.registry = registryManager.getMeterRegister(AlarmTimeSeriesMetric.alarmStreamMetrics().getId(), new String[0]);
        this.addMeasurement((Measurement)new AlarmRecordTrendMeasurement(timeSeriesManager));
        this.addMeasurement((Measurement)new AlarmRecordRankMeasurement(timeSeriesManager));
    }

    @EventListener
    public void aggAlarmRecord(AlarmHistoryInfo info) {
        this.registry.counter("record-agg", this.getTags(info)).increment();
    }

    public String[] getTags(AlarmHistoryInfo info) {
        LinkedHashMap tagMap = Maps.newLinkedHashMap();
        tagMap.put("targetId", info.getTargetId());
        tagMap.put("targetType", info.getTargetType());
        tagMap.put("targetName", info.getTargetName());
        tagMap.put("alarmConfigId", info.getAlarmConfigId());
        return ConverterUtils.convertMapToTags((Map)tagMap);
    }
}

