/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.jetlinks.community.rule.engine.enums.AlarmState;
import org.jetlinks.community.rule.engine.scene.TriggerType;

@Table(name="alarm_config", indexes={@Index(name="idx_ac_scene_id", columnList="scene_id")})
@Comment(value="\u544a\u8b66\u914d\u7f6e\u8868")
@EnableEntityEvent
public class AlarmConfigEntity
extends GenericEntity<String>
implements RecordCreationEntity,
RecordModifierEntity {
    @Column(length=64, nullable=false)
    @Schema(description="\u540d\u79f0")
    private String name;
    @Column(length=64, nullable=false)
    @Schema(description="\u544a\u8b66\u76ee\u6807\u7c7b\u578b")
    private String targetType;
    @Column(nullable=false)
    @Schema(description="\u544a\u8b66\u7ea7\u522b")
    private Integer level;
    @Column(length=128)
    @Schema(description="\u5173\u8054\u573a\u666f\u540d\u79f0")
    @Deprecated
    private String sceneName;
    @Column(length=64)
    @Schema(description="\u5173\u8054\u573a\u666fId")
    @Deprecated
    private String sceneId;
    @Column(length=32, nullable=false)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @DefaultValue(value="disabled")
    @Schema(description="\u72b6\u6001")
    private AlarmState state;
    @Column(length=32)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @Schema(description="\u573a\u666f\u89e6\u53d1\u7c7b\u578b")
    @Deprecated
    private TriggerType sceneTriggerType;
    @Column(length=256)
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Column(length=64, updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;
    @Column(length=64)
    @Schema(description="\u66f4\u65b0\u8005ID", accessMode=Schema.AccessMode.READ_ONLY)
    private String modifierId;
    @Column
    @DefaultValue(generator="current_time")
    @Schema(description="\u66f4\u65b0\u65f6\u95f4")
    private Long modifyTime;

    public Map<String, Object> toConfigMap() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("alarmConfigId", this.getId());
        configs.put("alarmName", this.getName());
        configs.put("level", this.getLevel());
        configs.put("ownerId", this.getModifierId() == null ? this.getCreatorId() : this.getModifierId());
        configs.put("targetType", this.getTargetType());
        configs.put("state", this.getState().name());
        return configs;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public Integer getLevel() {
        return this.level;
    }

    @Deprecated
    public String getSceneName() {
        return this.sceneName;
    }

    @Deprecated
    public String getSceneId() {
        return this.sceneId;
    }

    public AlarmState getState() {
        return this.state;
    }

    @Deprecated
    public TriggerType getSceneTriggerType() {
        return this.sceneTriggerType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getModifierId() {
        return this.modifierId;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Deprecated
    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    @Deprecated
    public void setSceneId(String sceneId) {
        this.sceneId = sceneId;
    }

    public void setState(AlarmState state) {
        this.state = state;
    }

    @Deprecated
    public void setSceneTriggerType(TriggerType sceneTriggerType) {
        this.sceneTriggerType = sceneTriggerType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }
}

