/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.jetlinks.community.rule.engine.alarm.AlarmLevelInfo;
import org.jetlinks.community.rule.engine.alarm.AlarmTargetSupplier;
import org.jetlinks.community.rule.engine.entity.AlarmConfigDetail;
import org.jetlinks.community.rule.engine.entity.AlarmConfigEntity;
import org.jetlinks.community.rule.engine.entity.AlarmLevelEntity;
import org.jetlinks.community.rule.engine.service.AlarmConfigService;
import org.jetlinks.community.rule.engine.web.response.AlarmTargetTypeInfo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/alarm/config"})
@Resource(id="alarm-config", name="\u544a\u8b66\u914d\u7f6e")
@Authorize
@Tag(name="\u544a\u8b66\u914d\u7f6e")
public class AlarmConfigController
implements ReactiveServiceCrudController<AlarmConfigEntity, String> {
    private final AlarmConfigService alarmConfigService;
    private final ReactiveRepository<AlarmLevelEntity, String> alarmLevelRepository;

    public ReactiveCrudService<AlarmConfigEntity, String> getService() {
        return this.alarmConfigService;
    }

    @PostMapping(value={"/{id}/_enable"})
    @Operation(summary="\u542f\u7528\u544a\u8b66\u914d\u7f6e")
    public Mono<Void> enable(@PathVariable String id) {
        return this.alarmConfigService.enable(id);
    }

    @PostMapping(value={"/{id}/_disable"})
    @Operation(summary="\u7981\u7528\u544a\u8b66\u914d\u7f6e")
    public Mono<Void> disable(@PathVariable String id) {
        return this.alarmConfigService.disable(id);
    }

    @GetMapping(value={"/target-type/supports"})
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u7684\u544a\u8b66\u76ee\u6807\u7c7b\u578b")
    public Flux<AlarmTargetTypeInfo> getTargetTypeSupports() {
        return Flux.fromIterable(AlarmTargetSupplier.get().getAll().values()).map(AlarmTargetTypeInfo::of);
    }

    @PatchMapping(value={"/default/level"})
    @Operation(summary="\u4fdd\u5b58\u9ed8\u8ba4\u544a\u8b66\u7ea7\u522b")
    @SaveAction
    public Mono<Void> saveAlarmLevel(@RequestBody Flux<AlarmLevelInfo> levelInfo) {
        return levelInfo.collectList().flatMap(info -> this.alarmLevelRepository.save((Object)AlarmLevelEntity.defaultOf(info))).then();
    }

    @PatchMapping(value={"/level"})
    @Operation(summary="\u4fdd\u5b58\u544a\u8b66\u7ea7\u522b")
    @SaveAction
    public Mono<Void> saveAlarmLevel(@RequestBody Mono<AlarmLevelEntity> entity) {
        return this.alarmLevelRepository.save(entity).then();
    }

    @PostMapping(value={"/detail/_query"})
    @Operation(summary="\u67e5\u8be2\u544a\u8b66\u914d\u7f6e\u8be6\u60c5")
    @QueryAction
    public Mono<PagerResult<AlarmConfigDetail>> queryDetailPager(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMap(this.alarmConfigService::queryDetailPager);
    }

    @GetMapping(value={"/default/level"})
    @Operation(summary=" \u83b7\u53d6\u9ed8\u8ba4\u544a\u8b66\u7ea7\u522b")
    @QueryAction
    public Mono<AlarmLevelEntity> queryAlarmLevel() {
        return this.alarmLevelRepository.findById((Object)"default-alarm-id");
    }

    public AlarmConfigController(AlarmConfigService alarmConfigService, ReactiveRepository<AlarmLevelEntity, String> alarmLevelRepository) {
        this.alarmConfigService = alarmConfigService;
        this.alarmLevelRepository = alarmLevelRepository;
    }
}

