/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.rule.engine.entity.SceneEntity;
import org.jetlinks.community.rule.engine.enums.RuleInstanceState;
import org.jetlinks.community.rule.engine.scene.SceneRule;
import org.jetlinks.community.rule.engine.web.request.SceneExecuteRequest;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.RuleEngine;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class SceneService
extends GenericReactiveCrudService<SceneEntity, String>
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SceneService.class);
    private final RuleEngine ruleEngine;

    public Mono<Void> execute(String id, Map<String, Object> data) {
        long t = System.currentTimeMillis();
        data.put("_now", t);
        data.put("timestamp", t);
        return this.ruleEngine.getTasks(id).filter(task -> task.getJob().getNodeId().equals(id)).next().flatMap(task -> task.execute(RuleData.create((Object)data))).then();
    }

    public Mono<Void> executeBatch(Flux<SceneExecuteRequest> requestFlux) {
        long t = System.currentTimeMillis();
        return requestFlux.doOnNext(request -> {
            if (request.getContext() == null) {
                request.setContext(new HashMap<String, Object>());
            }
            request.getContext().put("_now", t);
            request.getContext().put("timestamp", t);
        }).flatMap(request -> this.ruleEngine.getTasks(request.getId()).filter(task -> task.getJob().getNodeId().equals(request.getId())).next().flatMap(task -> task.execute(RuleData.create(request.getContext())))).then();
    }

    @Transactional(rollbackFor={Throwable.class})
    public Mono<SceneEntity> createScene(SceneRule rule) {
        if (!StringUtils.hasText((String)rule.getId())) {
            rule.setId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        }
        rule.validate();
        SceneEntity entity = new SceneEntity().with(rule);
        entity.setState(RuleInstanceState.disable);
        return this.insert((Object)entity).thenReturn((Object)entity);
    }

    @Transactional(rollbackFor={Throwable.class})
    public Mono<SceneEntity> updateScene(String id, SceneRule rule) {
        rule.setId(id);
        rule.validate();
        SceneEntity entity = new SceneEntity().with(rule);
        return this.updateById(id, (Object)entity).thenReturn((Object)entity);
    }

    @Transactional(rollbackFor={Throwable.class})
    public Mono<Void> enable(String id) {
        Assert.hasText((String)id, (String)"id can not be empty");
        long now = System.currentTimeMillis();
        return ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(SceneEntity::getState, (Object)RuleInstanceState.started)).set(SceneEntity::getModifyTime, (Object)now)).set(SceneEntity::getStartTime, (Object)now)).where(GenericEntity::getId, (Object)id)).execute().then();
    }

    @Transactional
    public Mono<Void> disabled(String id) {
        Assert.hasText((String)id, (String)"id can not be empty");
        return ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(SceneEntity::getState, (Object)RuleInstanceState.disable)).where(GenericEntity::getId, (Object)id)).execute().then();
    }

    @EventListener
    public void handleSceneSaved(EntitySavedEvent<SceneEntity> event) {
        event.async(this.handleEvent(event.getEntity()));
    }

    @EventListener
    public void handleSceneSaved(EntityModifyEvent<SceneEntity> event) {
        event.async(this.handleEvent(event.getAfter()));
    }

    @EventListener
    public void handleSceneSaved(EntityCreatedEvent<SceneEntity> event) {
        event.async((Publisher)((Flux)Flux.fromIterable((Iterable)event.getEntity()).map(GenericEntity::getId).as(arg_0 -> ((SceneService)this).findById(arg_0))).collectList().flatMap(this::handleEvent));
    }

    private Mono<Void> handleEvent(Collection<SceneEntity> entities) {
        return Flux.fromIterable(entities).flatMap(scene -> {
            if (scene.getState() == RuleInstanceState.disable) {
                return this.ruleEngine.shutdown((String)scene.getId());
            }
            if (scene.getState() == RuleInstanceState.started) {
                scene.validate();
                return this.ruleEngine.startRule((String)scene.getId(), scene.toRule().getModel());
            }
            return Mono.empty();
        }).then();
    }

    @EventListener
    public void handleSceneDelete(EntityDeletedEvent<SceneEntity> event) {
        for (SceneEntity entity : event.getEntity()) {
            entity.setState(RuleInstanceState.disable);
        }
        event.async(this.handleEvent(event.getEntity()));
    }

    public void run(String ... args) {
        ((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).is(SceneEntity::getState, (Object)RuleInstanceState.started)).fetch().flatMap(e -> Mono.defer(() -> this.ruleEngine.startRule((String)e.getId(), e.toRule().getModel()).then()).onErrorResume(err -> {
            log.warn("\u542f\u52a8\u573a\u666f[{}]\u5931\u8d25", (Object)e.getName(), err);
            return Mono.empty();
        })).subscribe();
    }

    public SceneService(RuleEngine ruleEngine) {
        this.ruleEngine = ruleEngine;
    }
}

