/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.scene;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.TimerSpec;
import org.jetlinks.community.rule.engine.commons.ShakeLimit;
import org.jetlinks.community.rule.engine.scene.DeviceTrigger;
import org.jetlinks.community.rule.engine.scene.TriggerType;
import org.jetlinks.community.rule.engine.scene.Variable;
import org.jetlinks.community.rule.engine.scene.term.limit.ShakeLimitGrouping;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.api.model.RuleNodeModel;
import org.springframework.util.Assert;

public class Trigger
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u89e6\u53d1\u65b9\u5f0f")
    @NotNull(message="error.scene_rule_trigger_cannot_be_null")
    private @NotNull(message="error.scene_rule_trigger_cannot_be_null") TriggerType type;
    @Schema(description="\u9632\u6296\u914d\u7f6e")
    private GroupShakeLimit shakeLimit;
    @Schema(description="[type]\u4e3a[device]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private DeviceTrigger device;
    @Schema(description="[type]\u4e3a[timer]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private TimerSpec timer;

    public List<Term> refactorTerm(String tableName, List<Term> terms) {
        if (org.springframework.util.CollectionUtils.isEmpty(terms)) {
            return terms;
        }
        ArrayList<Term> target = new ArrayList<Term>(terms.size());
        for (Term term : terms) {
            Term copy = term.clone();
            target.add(DeviceTrigger.refactorTermValue(tableName, copy));
            if (!CollectionUtils.isNotEmpty((Collection)copy.getTerms())) continue;
            copy.setTerms(this.refactorTerm(tableName, copy.getTerms()));
        }
        return target;
    }

    public void validate() {
        Assert.notNull((Object)((Object)this.type), (String)"error.scene_rule_trigger_cannot_be_null");
        if (this.type == TriggerType.device) {
            Assert.notNull((Object)this.device, (String)"error.scene_rule_trigger_device_cannot_be_null");
            this.device.validate();
        } else if (this.type == TriggerType.timer) {
            Assert.notNull((Object)this.timer, (String)"error.scene_rule_trigger_timer_cannot_be_null");
            this.timer.validate();
        }
    }

    public List<Variable> createDefaultVariable() {
        return this.type == TriggerType.device && this.device != null ? this.device.createDefaultVariable() : Collections.emptyList();
    }

    public static Trigger device(DeviceTrigger device) {
        Trigger trigger = new Trigger();
        trigger.setType(TriggerType.device);
        trigger.setDevice(device);
        return trigger;
    }

    public static Trigger manual() {
        Trigger trigger = new Trigger();
        trigger.setType(TriggerType.manual);
        return trigger;
    }

    void applyModel(RuleModel model, RuleNodeModel sceneNode) {
        if (this.type == TriggerType.timer) {
            RuleNodeModel timerNode = new RuleNodeModel();
            timerNode.setId("scene:timer");
            timerNode.setName("\u5b9a\u65f6\u89e6\u53d1\u573a\u666f");
            timerNode.setExecutor("timer");
            timerNode.setConfiguration((Map)FastBeanCopier.copy((Object)this.timer, new HashMap(), (String[])new String[0]));
            model.getNodes().add(timerNode);
            model.link(timerNode, sceneNode);
        }
        if (this.type == TriggerType.device) {
            this.device.applyModel(model, sceneNode);
        }
    }

    @NotNull(message="error.scene_rule_trigger_cannot_be_null")
    public @NotNull(message="error.scene_rule_trigger_cannot_be_null") TriggerType getType() {
        return this.type;
    }

    public GroupShakeLimit getShakeLimit() {
        return this.shakeLimit;
    }

    public DeviceTrigger getDevice() {
        return this.device;
    }

    public TimerSpec getTimer() {
        return this.timer;
    }

    public void setType(@NotNull(message="error.scene_rule_trigger_cannot_be_null") @NotNull(message="error.scene_rule_trigger_cannot_be_null") TriggerType type) {
        this.type = type;
    }

    public void setShakeLimit(GroupShakeLimit shakeLimit) {
        this.shakeLimit = shakeLimit;
    }

    public void setDevice(DeviceTrigger device) {
        this.device = device;
    }

    public void setTimer(TimerSpec timer) {
        this.timer = timer;
    }

    public static class GroupShakeLimit
    extends ShakeLimit {
        @Schema(description="\u5206\u7ec4\u7c7b\u578b:device,product,org...")
        @Hidden
        private String groupType;

        public ShakeLimitGrouping<Map<String, Object>> createGrouping() {
            return flux -> flux.groupBy(map -> map.getOrDefault("deviceId", "null"), Integer.MAX_VALUE);
        }

        public String getGroupType() {
            return this.groupType;
        }

        public void setGroupType(String groupType) {
            this.groupType = groupType;
        }
    }
}

