/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.entity;

import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.community.rule.engine.alarm.AlarmTargetInfo;
import org.jetlinks.community.rule.engine.entity.AlarmConfigEntity;
import org.jetlinks.community.rule.engine.scene.SceneData;

public class AlarmHistoryInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u544a\u8b66\u6570\u636eID")
    private String id;
    @Schema(description="\u544a\u8b66\u914d\u7f6eID")
    private String alarmConfigId;
    @Schema(description="\u544a\u8b66\u914d\u7f6e\u540d\u79f0")
    private String alarmConfigName;
    @Schema(description="\u544a\u8b66\u8bb0\u5f55ID")
    private String alarmRecordId;
    @Schema(description="\u544a\u8b66\u7ea7\u522b")
    private int level;
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Schema(description="\u544a\u8b66\u65f6\u95f4")
    private long alarmTime;
    @Schema(description="\u544a\u8b66\u76ee\u6807\u7c7b\u578b")
    private String targetType;
    @Schema(description="\u544a\u8b66\u76ee\u6807\u540d\u79f0")
    private String targetName;
    @Schema(description="\u544a\u8b66\u76ee\u6807Id")
    private String targetId;
    @Schema(description="\u544a\u8b66\u6e90\u7c7b\u578b")
    private String sourceType;
    @Schema(description="\u544a\u8b66\u6e90Id")
    private String sourceId;
    @Schema(description="\u544a\u8b66\u6e90\u540d\u79f0")
    private String sourceName;
    @Schema(description="\u544a\u8b66\u4fe1\u606f")
    private String alarmInfo;
    @Schema(description="\u7ed1\u5b9a\u4fe1\u606f")
    private List<Map<String, Object>> bindings;

    @Deprecated
    public static AlarmHistoryInfo of(String alarmRecordId, AlarmTargetInfo targetInfo, SceneData data, AlarmConfigEntity alarmConfig) {
        AlarmHistoryInfo info = new AlarmHistoryInfo();
        info.setAlarmConfigId((String)alarmConfig.getId());
        info.setAlarmConfigName(alarmConfig.getName());
        info.setAlarmRecordId(alarmRecordId);
        info.setLevel(alarmConfig.getLevel());
        info.setId(data.getId());
        info.setAlarmTime(System.currentTimeMillis());
        info.setTargetName(targetInfo.getTargetName());
        info.setTargetId(targetInfo.getTargetId());
        info.setTargetType(targetInfo.getTargetType());
        info.setSourceName(targetInfo.getSourceName());
        info.setSourceType(targetInfo.getSourceType());
        info.setSourceId(targetInfo.getSourceId());
        info.setAlarmInfo(JSON.toJSONString(data.getOutput()));
        info.setDescription(alarmConfig.getDescription());
        info.setBindings(AlarmHistoryInfo.convertBindings(targetInfo, data, alarmConfig));
        return info;
    }

    @Deprecated
    static List<Map<String, Object>> convertBindings(AlarmTargetInfo targetInfo, SceneData data, AlarmConfigEntity alarmConfig) {
        ArrayList<Map<String, Object>> bindings = new ArrayList<Map<String, Object>>();
        bindings.addAll(data.getOutput().getOrDefault("_bindings", Collections.emptyList()));
        HashMap<String, String> userDimension = new HashMap<String, String>(2);
        userDimension.put("type", "user");
        userDimension.put("id", alarmConfig.getCreatorId());
        bindings.add(userDimension);
        if ("org".equals(alarmConfig.getTargetType())) {
            HashMap orgDimension = new HashMap(2);
            userDimension.put("type", targetInfo.getTargetType());
            userDimension.put("id", targetInfo.getTargetId());
            bindings.add(userDimension);
        }
        return bindings;
    }

    public String getId() {
        return this.id;
    }

    public String getAlarmConfigId() {
        return this.alarmConfigId;
    }

    public String getAlarmConfigName() {
        return this.alarmConfigName;
    }

    public String getAlarmRecordId() {
        return this.alarmRecordId;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDescription() {
        return this.description;
    }

    public long getAlarmTime() {
        return this.alarmTime;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getAlarmInfo() {
        return this.alarmInfo;
    }

    public List<Map<String, Object>> getBindings() {
        return this.bindings;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAlarmConfigId(String alarmConfigId) {
        this.alarmConfigId = alarmConfigId;
    }

    public void setAlarmConfigName(String alarmConfigName) {
        this.alarmConfigName = alarmConfigName;
    }

    public void setAlarmRecordId(String alarmRecordId) {
        this.alarmRecordId = alarmRecordId;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAlarmTime(long alarmTime) {
        this.alarmTime = alarmTime;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setAlarmInfo(String alarmInfo) {
        this.alarmInfo = alarmInfo;
    }

    public void setBindings(List<Map<String, Object>> bindings) {
        this.bindings = bindings;
    }
}

