/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import javax.persistence.Column;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.jetlinks.community.rule.engine.alarm.AlarmHandleInfo;
import org.jetlinks.community.rule.engine.enums.AlarmHandleType;

@Table(name="alarm_handle_history")
@Comment(value="\u544a\u8b66\u5904\u7406\u8bb0\u5f55")
public class AlarmHandleHistoryEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    @Column(length=64, nullable=false, updatable=false)
    @Schema(description="\u544a\u8b66\u914d\u7f6eID")
    private String alarmId;
    @Column(length=64, nullable=false, updatable=false)
    @Schema(description="\u544a\u8b66\u8bb0\u5f55Id")
    private String alarmRecordId;
    @Column(length=64, nullable=false, updatable=false)
    @Schema(description="\u544a\u8b66\u5904\u7406\u7c7b\u578b")
    @EnumCodec
    @ColumnType(javaType=String.class)
    private AlarmHandleType handleType;
    @Column(length=256, nullable=false, updatable=false)
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Column(updatable=false)
    @Schema(description="\u5904\u7406\u65f6\u95f4")
    private Long handleTime;
    @Column(updatable=false)
    @Schema(description="\u544a\u8b66\u65f6\u95f4")
    private Long alarmTime;
    @Column(updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;

    public static AlarmHandleHistoryEntity of(AlarmHandleInfo handleInfo) {
        AlarmHandleHistoryEntity entity = new AlarmHandleHistoryEntity();
        entity.setAlarmId(handleInfo.getAlarmConfigId());
        entity.setAlarmRecordId(handleInfo.getAlarmRecordId());
        entity.setAlarmTime(handleInfo.getAlarmTime());
        entity.setHandleType(handleInfo.getType());
        entity.setDescription(handleInfo.getDescribe());
        entity.setHandleTime(handleInfo.getHandleTime() == null ? System.currentTimeMillis() : handleInfo.getHandleTime());
        return entity;
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public String getAlarmRecordId() {
        return this.alarmRecordId;
    }

    public AlarmHandleType getHandleType() {
        return this.handleType;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getHandleTime() {
        return this.handleTime;
    }

    public Long getAlarmTime() {
        return this.alarmTime;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setAlarmId(String alarmId) {
        this.alarmId = alarmId;
    }

    public void setAlarmRecordId(String alarmRecordId) {
        this.alarmRecordId = alarmRecordId;
    }

    public void setHandleType(AlarmHandleType handleType) {
        this.handleType = handleType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHandleTime(Long handleTime) {
        this.handleTime = handleTime;
    }

    public void setAlarmTime(Long alarmTime) {
        this.alarmTime = alarmTime;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

