/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.web.response;

import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.rule.engine.executor.PayloadType;

public class MqttMessageResponse {
    private int messageId;
    private Object payload;
    private String topic;
    private int qosLevel;
    private boolean dup;

    public static MqttMessageResponse of(MqttMessage mqttMessage, PayloadType type) {
        return MqttMessageResponse.builder().dup(mqttMessage.isDup()).payload(type.read(mqttMessage.getPayload())).messageId(mqttMessage.getMessageId()).qosLevel(mqttMessage.getQosLevel()).topic(mqttMessage.getTopic()).build();
    }

    public static MqttMessageResponseBuilder builder() {
        return new MqttMessageResponseBuilder();
    }

    public int getMessageId() {
        return this.messageId;
    }

    public Object getPayload() {
        return this.payload;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQosLevel() {
        return this.qosLevel;
    }

    public boolean isDup() {
        return this.dup;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setQosLevel(int qosLevel) {
        this.qosLevel = qosLevel;
    }

    public void setDup(boolean dup) {
        this.dup = dup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttMessageResponse)) {
            return false;
        }
        MqttMessageResponse other = (MqttMessageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMessageId() != other.getMessageId()) {
            return false;
        }
        if (this.getQosLevel() != other.getQosLevel()) {
            return false;
        }
        if (this.isDup() != other.isDup()) {
            return false;
        }
        Object this$payload = this.getPayload();
        Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqttMessageResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMessageId();
        result = result * 59 + this.getQosLevel();
        result = result * 59 + (this.isDup() ? 79 : 97);
        Object $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        return result;
    }

    public String toString() {
        return "MqttMessageResponse(messageId=" + this.getMessageId() + ", payload=" + this.getPayload() + ", topic=" + this.getTopic() + ", qosLevel=" + this.getQosLevel() + ", dup=" + this.isDup() + ")";
    }

    public MqttMessageResponse() {
    }

    public MqttMessageResponse(int messageId, Object payload, String topic, int qosLevel, boolean dup) {
        this.messageId = messageId;
        this.payload = payload;
        this.topic = topic;
        this.qosLevel = qosLevel;
        this.dup = dup;
    }

    public static class MqttMessageResponseBuilder {
        private int messageId;
        private Object payload;
        private String topic;
        private int qosLevel;
        private boolean dup;

        MqttMessageResponseBuilder() {
        }

        public MqttMessageResponseBuilder messageId(int messageId) {
            this.messageId = messageId;
            return this;
        }

        public MqttMessageResponseBuilder payload(Object payload) {
            this.payload = payload;
            return this;
        }

        public MqttMessageResponseBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public MqttMessageResponseBuilder qosLevel(int qosLevel) {
            this.qosLevel = qosLevel;
            return this;
        }

        public MqttMessageResponseBuilder dup(boolean dup) {
            this.dup = dup;
            return this;
        }

        public MqttMessageResponse build() {
            return new MqttMessageResponse(this.messageId, this.payload, this.topic, this.qosLevel, this.dup);
        }

        public String toString() {
            return "MqttMessageResponse.MqttMessageResponseBuilder(messageId=" + this.messageId + ", payload=" + this.payload + ", topic=" + this.topic + ", qosLevel=" + this.qosLevel + ", dup=" + this.dup + ")";
        }
    }
}

