/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.gateway.DeviceGateway;
import org.jetlinks.community.gateway.DeviceGatewayManager;
import org.jetlinks.community.network.manager.entity.DeviceGatewayEntity;
import org.jetlinks.community.network.manager.enums.DeviceGatewayState;
import org.jetlinks.community.network.manager.service.DeviceGatewayService;
import org.jetlinks.community.network.manager.web.response.DeviceGatewayDetail;
import org.jetlinks.community.network.manager.web.response.DeviceGatewayProviderInfo;
import org.jetlinks.community.utils.ReactorUtils;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.device.session.DeviceSessionInfo;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.reactivestreams.Publisher;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@RestController
@RequestMapping(value={"/gateway/device"})
@Resource(id="device-gateway", name="\u8bbe\u5907\u63a5\u5165\u7f51\u5173")
@Authorize
@Tag(name="\u8bbe\u5907\u63a5\u5165\u7ba1\u7406")
public class DeviceGatewayController
implements ReactiveServiceCrudController<DeviceGatewayEntity, String> {
    private final DeviceGatewayService deviceGatewayService;
    private final ProtocolSupports protocolSupports;
    private final DeviceGatewayManager gatewayManager;
    private final DeviceSessionManager sessionManager;

    @Generated
    public DeviceGatewayService getService() {
        return this.deviceGatewayService;
    }

    @PostMapping(value={"/{id}/_startup"})
    @SaveAction
    @Operation(summary="\u542f\u52a8\u7f51\u5173")
    public Mono<Void> startup(@PathVariable @Parameter(description="\u7f51\u5173ID") String id) {
        return this.gatewayManager.start(id).then(this.deviceGatewayService.updateState(id, DeviceGatewayState.enabled)).then();
    }

    @PostMapping(value={"/{id}/_pause"})
    @SaveAction
    @Operation(summary="\u6682\u505c")
    public Mono<Void> pause(@PathVariable @Parameter(description="\u7f51\u5173ID") String id) {
        return this.gatewayManager.getGateway(id).flatMap(DeviceGateway::pause).then(this.deviceGatewayService.updateState(id, DeviceGatewayState.paused)).then();
    }

    @PostMapping(value={"/{id}/_shutdown"})
    @SaveAction
    @Operation(summary="\u505c\u6b62")
    public Mono<Void> shutdown(@PathVariable @Parameter(description="\u7f51\u5173ID") String id) {
        return this.gatewayManager.shutdown(id).then(this.deviceGatewayService.updateState(id, DeviceGatewayState.disabled).then());
    }

    @GetMapping(value={"/{id}/detail"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u5355\u4e2a\u63a5\u5165\u7f51\u5173\u8be6\u60c5")
    public Mono<DeviceGatewayDetail> getDetail(@PathVariable @Parameter(description="\u7f51\u5173ID") String id) {
        return this.deviceGatewayService.findById(id).flatMap(this::convertDetail);
    }

    @PostMapping(value={"/detail/_query"})
    @QueryAction
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u8bbe\u5907\u63a5\u5165\u7f51\u5173\u8be6\u60c5")
    public Mono<PagerResult<DeviceGatewayDetail>> queryGateway(@RequestBody Mono<QueryParamEntity> paramBody) {
        return paramBody.flatMap(param -> this.deviceGatewayService.queryPager((QueryParamEntity)param).flatMap(result -> Flux.fromIterable((Iterable)result.getData()).index().flatMap(tp2 -> this.convertDetail((DeviceGatewayEntity)((Object)((Object)((Object)((Object)tp2.getT2()))))).map(detail -> Tuples.of((Object)tp2.getT1(), (Object)detail))).sort(Comparator.comparingLong(Tuple2::getT1)).map(Tuple2::getT2).collectList().map(detail -> PagerResult.of((int)result.getTotal(), (List)detail, (QueryParam)param))));
    }

    private Mono<DeviceGatewayDetail> convertDetail(DeviceGatewayEntity entity) {
        DeviceGatewayDetail detail = DeviceGatewayDetail.of(entity);
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = this.gatewayManager.getChannel(entity.getChannel(), entity.getChannelId()).map(detail::with);
        publisherArray[1] = entity.getProtocol() == null ? Mono.empty() : this.protocolSupports.getProtocol(entity.getProtocol()).onErrorResume(err -> Mono.empty()).flatMap(detail::with);
        return Flux.merge((Publisher[])publisherArray).last((Object)detail);
    }

    @GetMapping(value={"/providers"})
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u7684\u63a5\u5165\u65b9\u5f0f")
    public Flux<DeviceGatewayProviderInfo> getProviders() {
        return LocaleUtils.currentReactive().flatMapMany(locale -> Flux.fromIterable((Iterable)this.gatewayManager.getProviders()).map(provider -> DeviceGatewayProviderInfo.of(provider, locale)));
    }

    @GetMapping(value={"/sessions"})
    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u4f1a\u8bdd\u4fe1\u606f")
    public Flux<DeviceSessionInfo> sessions(@RequestParam(required=false) Long pageIndex, @RequestParam(required=false) Long pageSize) {
        return (Flux)this.sessionManager.getSessionInfo().as(ReactorUtils.limit((Long)pageIndex, (Long)pageSize));
    }

    @GetMapping(value={"/sessions/{serverId}"})
    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u4f1a\u8bdd\u4fe1\u606f")
    public Flux<DeviceSessionInfo> sessions(@PathVariable String serverId, @RequestParam(required=false) Long pageIndex, @RequestParam(required=false) Long pageSize) {
        return (Flux)this.sessionManager.getSessionInfo(serverId).as(ReactorUtils.limit((Long)pageIndex, (Long)pageSize));
    }

    @DeleteMapping(value={"/session/{deviceId}"})
    @Operation(summary="\u79fb\u9664\u8bbe\u5907\u4f1a\u8bdd")
    @SaveAction
    public Mono<Long> removeSession(@PathVariable String deviceId) {
        return this.sessionManager.remove(deviceId, false);
    }

    public DeviceGatewayController(DeviceGatewayService deviceGatewayService, ProtocolSupports protocolSupports, DeviceGatewayManager gatewayManager, DeviceSessionManager sessionManager) {
        this.deviceGatewayService = deviceGatewayService;
        this.protocolSupports = protocolSupports;
        this.gatewayManager = gatewayManager;
        this.sessionManager = sessionManager;
    }
}

