/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.session;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.utils.DigestUtils;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DashboardDefinition;
import org.jetlinks.community.dashboard.DefaultDashboardDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.ObjectDefinition;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.dashboard.supports.StaticMeasurementProvider;
import org.jetlinks.community.gateway.monitor.measurements.GatewayObjectDefinition;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesMetadata;
import org.jetlinks.community.timeseries.TimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesService;
import org.jetlinks.community.timeseries.query.Aggregation;
import org.jetlinks.community.timeseries.query.AggregationQueryParam;
import org.jetlinks.community.utils.TimeUtils;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.core.server.session.DeviceSession;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Component;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Component
public class DeviceSessionMeasurementProvider
extends StaticMeasurementProvider {
    private final DeviceSessionManager sessionManager;
    private final TimeSeriesMetric metric;
    private final TimeSeriesManager timeSeriesManager;
    private final Duration interval = TimeUtils.parse((String)System.getProperty("device.session.report.interval", "1h"));
    private final Disposable.Composite disposable = Disposables.composite();

    public DeviceSessionMeasurementProvider(DeviceSessionManager sessionManager, TimeSeriesManager timeSeriesManager) {
        super((DashboardDefinition)DefaultDashboardDefinition.device, (ObjectDefinition)GatewayObjectDefinition.session);
        this.sessionManager = sessionManager;
        this.metric = TimeSeriesMetric.of((String)"device_session_metric");
        this.timeSeriesManager = timeSeriesManager;
        this.addMeasurement((Measurement)new StaticMeasurement(MeasurementDefinition.of((String)"online", (String)"\u5728\u7ebf\u7edf\u8ba1")).addDimension((MeasurementDimension)new DeviceSessionMeasurementDimension()));
    }

    @PostConstruct
    public void init() {
        this.timeSeriesManager.registerMetadata(TimeSeriesMetadata.of((TimeSeriesMetric)this.metric, (PropertyMetadata[])new PropertyMetadata[]{SimplePropertyMetadata.of((String)"server", (String)"server", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"duration", (String)"duration", (DataType)IntType.GLOBAL), SimplePropertyMetadata.of((String)"count", (String)"count", (DataType)IntType.GLOBAL), SimplePropertyMetadata.of((String)"bindings", (String)"bindings", (DataType)new ArrayType().elementType((DataType)StringType.GLOBAL)), SimplePropertyMetadata.of((String)"connectTime", (String)"connectTime", (DataType)DateTimeType.GLOBAL)})).block(Duration.ofSeconds(30L));
        Scheduler scheduler = Schedulers.newSingle((String)"device-session-reporter");
        this.disposable.add((Disposable)scheduler);
        if (!this.interval.isZero() && !this.interval.isNegative()) {
            this.disposable.add(Flux.interval((Duration)this.interval, (Scheduler)scheduler).flatMap(ignore -> this.reportDeviceSession()).subscribe());
        }
        this.disposable.add(this.sessionManager.listenEvent(event -> this.reportDeviceSession(event.getSession(), "session")));
    }

    @PreDestroy
    public void shutdown() {
        this.disposable.dispose();
    }

    private Mono<Void> reportDeviceSession() {
        return this.sessionManager.getSessions().flatMap(this::reportDeviceSession).onErrorResume(err -> Mono.empty()).then();
    }

    protected Mono<Void> reportDeviceSession(DeviceSession session) {
        return this.reportDeviceSession(session, "check");
    }

    private long computeDuration(long timestamp) {
        return System.currentTimeMillis() - timestamp;
    }

    protected Mono<Void> reportDeviceSession(DeviceSession session, String type) {
        if (null == session.getOperator()) {
            return Mono.empty();
        }
        return ((Mono)session.getOperator().getSelfConfigs(new ConfigKey[]{DeviceConfigKey.productId}).map(configs -> {
            HashMap data = Maps.newHashMapWithExpectedSize((int)16);
            data.put("id", DigestUtils.md5Hex((String)String.join((CharSequence)"-", session.getDeviceId(), String.valueOf(session.connectTime()), this.sessionManager.getCurrentServerId(), "session".equals(type) ? "session" : String.valueOf((int)(System.currentTimeMillis() / this.interval.toMillis())))));
            data.put("name", "duration");
            data.put("productId", configs.getValue((ConfigKey)DeviceConfigKey.productId).orElse(""));
            data.put("deviceId", session.getDeviceId());
            data.put("server", this.sessionManager.getCurrentServerId());
            data.put("connectTime", session.connectTime());
            data.put("duration", this.computeDuration(session.connectTime()));
            data.put("type", type);
            return TimeSeriesData.of((long)System.currentTimeMillis(), (Map)data);
        }).as(arg_0 -> ((TimeSeriesService)this.timeSeriesManager.getService(this.metric)).commit(arg_0))).onErrorResume(err -> Mono.empty());
    }

    class DeviceSessionMeasurementDimension
    implements MeasurementDimension {
        DeviceSessionMeasurementDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.agg;
        }

        public DataType getValueType() {
            return new ObjectType();
        }

        public ConfigMetadata getParams() {
            return new DefaultConfigMetadata();
        }

        public boolean isRealTime() {
            return false;
        }

        private AggregationQueryParam createQuery(MeasurementParameter parameter) {
            return AggregationQueryParam.of().agg("deviceId", "count", Aggregation.DISTINCT_COUNT).groupBy(parameter.getInterval("interval", parameter.getInterval("time", null)), parameter.getString("format", "yyyy-MM-dd")).from(parameter.getDate("from", TimeUtils.parseDate((String)"now-1d"))).to(parameter.getDate("to").orElseGet(Date::new)).filter(q -> {
                Query cfr_ignored_0 = (Query)((Query)((Query)q.is("name", (Object)"duration")).is("productId", (Object)parameter.getString("productId", null))).is("deviceId", (Object)parameter.getString("deviceId", null));
            });
        }

        public Publisher<? extends Object> getValue(MeasurementParameter parameter) {
            AggregationQueryParam queryParam = this.createQuery(parameter);
            String format = parameter.getString("format", "yyyy-MM-dd");
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
            return DeviceSessionMeasurementProvider.this.timeSeriesManager.getService(DeviceSessionMeasurementProvider.this.metric).aggregation(queryParam).map(data -> SimpleMeasurementValue.of((Object)data.getLong("count", 0L), (String)data.getString("time", ""), (long)data.getString("time").map(arg_0 -> ((DateTimeFormatter)formatter).parseMillis(arg_0)).orElse(0L))).sort().take((long)parameter.getInt("limit", 30));
        }
    }
}

