/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.service;

import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.exception.NotFoundException;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.manager.entity.NetworkConfigEntity;
import org.jetlinks.community.network.manager.enums.NetworkConfigState;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class NetworkConfigService
extends GenericReactiveCrudService<NetworkConfigEntity, String> {
    private final NetworkManager networkManager;

    public NetworkConfigService(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return (Mono)this.findById(Flux.from(idPublisher)).flatMap(config -> this.networkManager.destroy(config.lookupNetworkType(), (String)config.getId()).thenReturn(config.getId())).as(x$0 -> super.deleteById(x$0));
    }

    public Mono<Void> start(String id) {
        return this.findById(id).switchIfEmpty(Mono.error(() -> new NotFoundException("error.configuration_does_not_exist", new Object[]{id}))).flatMap(conf -> ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(NetworkConfigEntity::getState, (Object)NetworkConfigState.enabled)).where(() -> ((NetworkConfigEntity)((Object)conf)).getId())).execute().thenReturn((Object)conf)).flatMap(conf -> this.networkManager.reload(conf.lookupNetworkType(), id));
    }

    public Mono<Void> shutdown(String id) {
        return this.findById(id).switchIfEmpty(Mono.error(() -> new NotFoundException("error.configuration_does_not_exist", new Object[]{id}))).flatMap(conf -> ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(NetworkConfigEntity::getState, (Object)NetworkConfigState.disabled)).where(() -> ((NetworkConfigEntity)((Object)conf)).getId())).execute().thenReturn((Object)conf)).flatMap(conf -> this.networkManager.shutdown(conf.lookupNetworkType(), id));
    }
}

