/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.debug;

import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.SubscriptionProvider;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.manager.debug.DebugUtils;
import org.jetlinks.community.network.tcp.TcpMessage;
import org.jetlinks.community.network.tcp.client.TcpClient;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

@Component
public class TcpServerDebugSubscriptionProvider
implements SubscriptionProvider {
    private final NetworkManager networkManager;

    public TcpServerDebugSubscriptionProvider(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    public String id() {
        return "network-tcp-server-debug";
    }

    public String name() {
        return "TCP\u670d\u52a1\u8c03\u8bd5";
    }

    public String[] getTopicPattern() {
        return new String[]{"/network/tcp/server/*/_subscribe"};
    }

    public Flux<TcpClientMessage> subscribe(SubscribeRequest request) {
        String id = request.getTopic().split("[/]")[4];
        return this.subscribe(id, request);
    }

    public Flux<TcpClientMessage> subscribe(String id, SubscribeRequest request) {
        String message = request.getString("response").filter(StringUtils::hasText).orElse(null);
        byte[] payload = DebugUtils.stringToBytes(message);
        return Flux.create(sink -> sink.onDispose(this.networkManager.getNetwork((NetworkType)DefaultNetworkType.TCP_SERVER, id).flatMap(server -> server.handleConnection().doOnNext(client -> sink.next((Object)TcpClientMessage.of(client))).flatMap(client -> {
            client.onDisconnect(() -> sink.next((Object)TcpClientMessage.ofDisconnect(client)));
            return client.subscribe().map(msg -> TcpClientMessage.of(client, msg)).doOnNext(arg_0 -> ((FluxSink)sink).next(arg_0)).flatMap(msg -> {
                if (payload.length > 0) {
                    return client.send(new TcpMessage(Unpooled.wrappedBuffer((byte[])payload)));
                }
                return Mono.empty();
            }).then();
        }).then()).doOnError(arg_0 -> ((FluxSink)sink).error(arg_0)).subscriberContext(sink.currentContext()).subscribe()));
    }

    public static class TcpClientMessage {
        private String type;
        private String typeText;
        private Object data;

        public static TcpClientMessage of(TcpClient client) {
            HashMap<String, InetSocketAddress> data = new HashMap<String, InetSocketAddress>();
            data.put("address", client.getRemoteAddress());
            return TcpClientMessage.of("connection", "\u8fde\u63a5", data);
        }

        public static TcpClientMessage ofDisconnect(TcpClient client) {
            HashMap<String, InetSocketAddress> data = new HashMap<String, InetSocketAddress>();
            data.put("address", client.getRemoteAddress());
            return TcpClientMessage.of("disconnection", "\u65ad\u5f00\u8fde\u63a5", data);
        }

        public static TcpClientMessage of(TcpClient connection, TcpMessage message) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("address", connection.getRemoteAddress().toString());
            data.put("message", message.toString());
            return TcpClientMessage.of("publish", "\u8ba2\u9605", data);
        }

        private TcpClientMessage(String type, String typeText, Object data) {
            this.type = type;
            this.typeText = typeText;
            this.data = data;
        }

        public static TcpClientMessage of(String type, String typeText, Object data) {
            return new TcpClientMessage(type, typeText, data);
        }

        public String getType() {
            return this.type;
        }

        public String getTypeText() {
            return this.typeText;
        }

        public Object getData() {
            return this.data;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setTypeText(String typeText) {
            this.typeText = typeText;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

