/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.debug;

import io.netty.buffer.Unpooled;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.SubscriptionProvider;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.manager.debug.DebugUtils;
import org.jetlinks.community.network.tcp.TcpMessage;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

@Component
public class TcpClientDebugSubscriptionProvider
implements SubscriptionProvider {
    private final NetworkManager networkManager;

    public TcpClientDebugSubscriptionProvider(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    public String id() {
        return "network-tcp-client-debug";
    }

    public String name() {
        return "TCP\u5ba2\u6237\u7aef\u8c03\u8bd5";
    }

    public String[] getTopicPattern() {
        return new String[]{"/network/tcp/client/*/_send", "/network/tcp/client/*/_subscribe"};
    }

    public Flux<String> subscribe(SubscribeRequest request) {
        String id = request.getTopic().split("[/]")[4];
        if (request.getTopic().endsWith("_send")) {
            return this.send(id, request);
        }
        return this.subscribe(id, request);
    }

    public Flux<String> send(String id, SubscribeRequest request) {
        String message = (String)request.getString("request").orElseThrow(() -> new IllegalArgumentException("\u53c2\u6570[request]\u4e0d\u80fd\u4e3a\u7a7a"));
        byte[] payload = DebugUtils.stringToBytes(message);
        return this.networkManager.getNetwork((NetworkType)DefaultNetworkType.TCP_CLIENT, id).flatMap(client -> client.send(new TcpMessage(Unpooled.wrappedBuffer((byte[])payload)))).thenReturn((Object)"\u63a8\u9001\u6210\u529f").flux();
    }

    public Flux<String> subscribe(String id, SubscribeRequest request) {
        String message = request.getString("response").filter(StringUtils::hasText).orElse(null);
        byte[] payload = DebugUtils.stringToBytes(message);
        return this.networkManager.getNetwork((NetworkType)DefaultNetworkType.TCP_CLIENT, id).flatMapMany(client -> client.subscribe().flatMap(msg -> client.send(new TcpMessage(Unpooled.wrappedBuffer((byte[])payload))).thenReturn(msg)).map(TcpMessage::toString));
    }
}

