package net.zstong.awump.monitoring.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.zstong.awump.base.entity.AwRegionEntity;
import net.zstong.awump.base.entity.BaseEntity;
import net.zstong.awump.base.entity.BaseTreeSortEntity;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author yuanhc
* @date 2023-07-07
*/
@Getter
@Setter
@Table(name="aw_monitoring_area")
@Comment("监控区域信息")
@EnableEntityEvent
public class AwMonitoringAreaEntity extends BaseTreeSortEntity<String> {


    @Schema(description = "子节点")
    private List<AwMonitoringAreaEntity> children;

    /** 所属单位 */
    @Schema(description = "所属单位")
    @Column(name = "institution_id_",length =64 )
    private String institutionId;


    /** 所属库房 */
    @Schema(description = "所属库房")
    @Column(name = "warehouse_id_",length =64 )
    private String warehouseId;


    /** 父ID */
    @Schema(description = "父ID")
    @Column(name = "parent_id",length =64 )
    private String parentId;


    /** 区域名称 */
    @Schema(description = "区域名称")
    @Column(name = "name_",nullable = false,length =256 )
    @NotBlank(message = "区域名称不能为空", groups = CreateGroup.class)
    private String name;


    /** 区域编码 */
    @Schema(description = "区域编码")
    @Column(name = "code_",length =64 )
    private String code;


    /** 树层级 */
    @Schema(description = "树层级")
    @Column(name = "_level")
    private Integer Level;


    /** 树路径 */
    @Schema(description = "树路径")
    @Column(name = "path",length =128 )
    private String path;


    /** 树序号 */
    @Schema(description = "树序号")
    @Column(name = "sort_index")
    private Long sortIndex;


    /** 描述 */
    @Schema(description = "描述")
    @Column(name = "describe_",length =200 )
    private String describe;











}