package net.zstong.awump.inspection.web;

import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import net.zstong.awump.base.service.AwRegionService;
import net.zstong.awump.inspection.entity.AwInspectionPlanEntity;
import net.zstong.awump.inspection.service.AwInspectionPlanService;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping({"/aw/inspection/plan"})
@Resource(id = "aw-inspection-plan", name = "巡检计划接口")
@Tag(name = "巡检计划接口")
@Slf4j
public class AwInspectionPlanController implements ReactiveServiceCrudController<AwInspectionPlanEntity, String> {

    @Autowired
    private AwInspectionPlanService awInspectionPlanService;

    @Autowired
    private AwRegionService awRegionService;

    @Override
    public ReactiveCrudService<AwInspectionPlanEntity, String> getService() {
        return awInspectionPlanService;
    }


}
