package net.zstong.awump.device.web.response;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.zstong.awump.base.entity.AwIntensiveFrameEntity;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.enums.DeviceState;

import javax.persistence.Column;


/**
 * 设备信息
 */
@Getter
@Setter
public class DeviceInfo {

    private String id;

    private String name;

    private String description;

    private String serverAddr;

    private DeviceState state;


    private String code;

    private String location;

    private String model;


    /** 品牌 */
    @Schema(description = "品牌")
    private String brand;


    /** 负责人 */
    @Schema(description = "负责人")
    private String custodian;


    /** 负责人联系方式 */
    @Schema(description = "负责人联系方式")
    private String phone;



    public static DeviceInfo of(DeviceInstanceEntity instance) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setId(instance.getId());
        deviceInfo.setName(instance.getName());
        deviceInfo.setState(instance.getState());
        deviceInfo.setDescription(instance.getDescribe());
        deviceInfo.setBrand(instance.getBrand());
        deviceInfo.setCustodian(instance.getCustodian());
        deviceInfo.setPhone(instance.getPhone());
        deviceInfo.setCode(instance.getCode());
        deviceInfo.setPhone(instance.getPhone());

        return deviceInfo;
    }

    public static DeviceInfo of(AwIntensiveFrameEntity mjj) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setId(mjj.getId());
        deviceInfo.setName(mjj.getName());
        deviceInfo.setBrand(mjj.getBrand());
        deviceInfo.setCustodian(mjj.getCustodian());
        deviceInfo.setPhone(mjj.getPhone());
        deviceInfo.setCode(mjj.getCode());
        deviceInfo.setPhone(mjj.getPhone());
        deviceInfo.setDescription(mjj.getMemo());
        deviceInfo.setServerAddr(mjj.getLinkAddress());
        return deviceInfo;
    }

}
