package net.zstong.awump.device.web;

import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Resource;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.rule.engine.entity.SceneEntity;
import org.jetlinks.community.rule.engine.executor.device.SelectorValue;
import org.jetlinks.community.rule.engine.service.SceneService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.util.stream.Collectors;


@RestController
@RequestMapping({"/aw/dev/rule"})
@Resource(id = "aw-dev-rule", name = "设备联动规则接口")
@Tag(name = "设备联动规则接口")
@Slf4j
public class RuleController {

    @Autowired
    private LocalDeviceInstanceService deviceInstanceService;

    @Autowired
    private SceneService sceneService;


    @PostMapping("/scene")
    @QueryNoPagingOperation(summary = "获取设备联动规则")
    public Mono<PagerResult<SceneEntity>> getDeviceInfo(@RequestBody Mono<QueryParamEntity> query) {
        System.out.println("================query===========" + JSON.toJSON(query));

        return query.flatMap((q) -> {
            q.setPaging(false);
            Object deviceId = null;
            for(Term t: q.getTerms()){
                if("deviceId".equals(t.getColumn())){
                    deviceId = t.getValue();
                }
            }
            final Object devId = deviceId;
            return sceneService.queryPager(q).map(p -> {
                return PagerResult.of(p.getTotal(),
                    p.getData().stream().filter(e -> {
                        //按设备过滤
                        if (e.getTrigger() != null
                            && e.getTrigger().getDevice() != null
                            && e.getTrigger().getDevice().getSelectorValues() != null) {
                            for(SelectorValue s : e.getTrigger().getDevice().getSelectorValues()){
                                if(s.getValue().equals(devId)){
                                    return true;
                                }
                            }

                        }
                        return false;
                    }).collect(Collectors.toList())
                    , q);
            });
        });

//        return sceneService.createQuery().where(SceneEntity::getTriggerType, "device").orderBy(SortOrder.desc(SceneEntity::getCreateTime)).fetch().collectList().map((list) -> {
//            return PagerResult.of(0, list, query);
//        });
    }
}
