package net.zstong.awump.base.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
* @author yuanhc
* @date 2023-05-26
*/
@Getter
@Setter
@Table(name="aw_warehouse")
@Comment("库房信息")
@EnableEntityEvent
public class AwWarehouseEntity extends BaseEntity<String>{



    /** 所属区域 */
    @Schema(description = "所属区域")
    @Column(name = "region_id_",length =64 )
    private String regionId;


    /** 所属单位 */
    @Schema(description = "所属单位")
    @Column(name = "institution_id_",length =64 )
    private String institutionId;


    /** 库房名称 */
    @Schema(description = "库房名称")
    @Column(name = "name_",nullable = false,length =256 )
    @NotBlank(message = "库房名称不能为空", groups = CreateGroup.class)
    private String name;


    /** 库房编码 */
    @Schema(description = "库房编码")
    @Column(name = "code_",length =64 )
    private String code;


    /** 类型 */
    @Schema(description = "类型")
    @Column(name = "warehouse_type_",length =32 )
    private String warehouseType;


    /** 描述 */
    @Schema(description = "描述")
    @Column(name = "describe_",length =200 )
    private String describe;











}