package net.zstong.awump.base.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hswebframework.web.authorization.Dimension;
import org.springframework.beans.BeanUtils;

/**
 * @author yuanhc
 * @date 2023-05-25
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class AwInstitutionInfo extends BaseEntity<String> {


    /**
     * 所属区域
     */
    @Schema(description = "所属区域ID")
    private String regionId;


    @Schema(description = "所属区域")
    private AwRegionEntity region;

    @Schema(description = "所属省份")
    private AwRegionEntity province;

    @Schema(description = "所属市级")
    private AwRegionEntity city;

    /**
     * 单位名称
     */
    @Schema(description = "单位名称")
    private String name;

    /**
     * 单位编码
     */
    @Schema(description = "单位编码")
    private String code;

    /**
     * 单位类型
     */
    @Schema(description = "单位类型")
    private String institutionType;

    /**
     * 描述
     */
    @Schema(description = "描述")
    private String describe;


    public static AwInstitutionInfo of(AwInstitutionEntity awInstitutionEntity) {
        AwInstitutionInfo awInstitutionInfo = new AwInstitutionInfo();
        BeanUtils.copyProperties(awInstitutionEntity, awInstitutionInfo);
        return awInstitutionInfo;
    }

}