/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web;

import com.alibaba.fastjson.JSONObject;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.jetlinks.community.auth.entity.UserDetail;
import org.jetlinks.community.auth.service.UserDetailService;
import org.jetlinks.community.auth.service.request.SaveUserDetailRequest;
import org.jetlinks.community.auth.service.request.SaveUserRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/user/detail"})
@Tag(name="\u7528\u6237\u4fe1\u606f\u63a5\u53e3")
@Resource(id="user", name="\u7cfb\u7edf\u7528\u6237", group={"system"})
public class UserDetailController {
    private final UserDetailService userDetailService;

    @PostMapping(value={"/_create"})
    @SaveAction
    @Operation(summary="\u521b\u5efa\u7528\u6237")
    @Transactional
    public Mono<String> createUser(@RequestBody Mono<SaveUserRequest> body) {
        return body.flatMap(this.userDetailService::saveUser);
    }

    @PutMapping(value={"/{userId}/_update"})
    @SaveAction
    @Operation(summary="\u4fee\u6539\u7528\u6237")
    public Mono<String> updateUser(@PathVariable String userId, @RequestBody Mono<SaveUserRequest> body) {
        return body.doOnNext(request -> {
            if (request.getUser() != null) {
                request.getUser().setId(userId);
            }
        }).flatMap(this.userDetailService::saveUser);
    }

    @GetMapping(value={"/{userId}"})
    @SaveAction
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u8be6\u60c5\u4fe1\u606f")
    public Mono<UserDetail> getUserDetail(@PathVariable String userId) {
        return this.userDetailService.findUserDetail(userId);
    }

    @PostMapping(value={"/_query"})
    @QueryAction
    @Operation(summary="\u5206\u9875\u83b7\u53d6\u7528\u6237\u8be6\u60c5")
    public Mono<PagerResult<UserDetail>> queryUserDetail(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMap(this.userDetailService::queryUserDetail);
    }

    @GetMapping(value={"/types"})
    @QueryAction
    public Flux<JSONObject> queryTypes() {
        System.out.println("=================types==============types============");
        Flux r = Flux.just((Object[])new JSONObject[]{new JSONObject().fluentPut("id", (Object)"normal").fluentPut("name", (Object)"\u666e\u901a\u7528\u6237"), new JSONObject().fluentPut("id", (Object)"external").fluentPut("name", (Object)"\u7b2c\u4e09\u65b9\u7528\u6237"), new JSONObject().fluentPut("id", (Object)"other").fluentPut("name", (Object)"\u5176\u5b83")});
        return r;
    }

    @GetMapping
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u8be6\u60c5")
    @Authorize(merge=false)
    public Mono<UserDetail> getCurrentLoginUserDetail() {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(autz -> this.userDetailService.findUserDetail(autz.getUser().getId()).switchIfEmpty(Mono.fromSupplier(() -> new UserDetail().with((Authentication)autz))));
    }

    @PutMapping
    @Operation(summary="\u4fdd\u5b58\u5f53\u524d\u7528\u6237\u8be6\u60c5")
    @Authorize(merge=false)
    public Mono<Void> saveUserDetail(@RequestBody Mono<SaveUserDetailRequest> request) {
        return Authentication.currentReactive().zipWith(request).switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(tp2 -> this.userDetailService.saveUserDetail(((Authentication)tp2.getT1()).getUser().getId(), (SaveUserDetailRequest)tp2.getT2()));
    }

    public UserDetailController(UserDetailService userDetailService) {
        this.userDetailService = userDetailService;
    }
}

