/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.jetlinks.community.auth.entity.OrganizationEntity;
import org.jetlinks.community.auth.service.OrganizationService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RequestMapping(value={"/organization"})
@RestController
@Resource(id="organization", name="\u90e8\u95e8\u7ba1\u7406")
@Tag(name="\u90e8\u95e8\u7ba1\u7406")
public class OrganizationController
implements ReactiveServiceCrudController<OrganizationEntity, String> {
    private final OrganizationService organizationService;

    public OrganizationController(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    private Flux<OrganizationEntity> queryAll() {
        return this.organizationService.createQuery().fetch();
    }

    private Flux<OrganizationEntity> queryAll(Mono<QueryParamEntity> queryParamEntity) {
        return this.organizationService.query(queryParamEntity);
    }

    @GetMapping(value={"/_all/tree"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u673a\u6784\u4fe1\u606f(\u6811\u7ed3\u6784)")
    public Flux<OrganizationEntity> getAllOrgTree() {
        return this.queryAll().collectList().flatMapIterable(list -> TreeSupportEntity.list2tree((Collection)list, OrganizationEntity::setChildren));
    }

    @PostMapping(value={"/_all/tree"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u673a\u6784\u4fe1\u606f(\u6811\u7ed3\u6784)")
    public Flux<OrganizationEntity> getAllOrgTree(@RequestBody Mono<QueryParamEntity> query) {
        return this.queryAll(query).collectList().flatMapIterable(list -> TreeSupportEntity.list2tree((Collection)list, OrganizationEntity::setChildren));
    }

    @GetMapping(value={"/_all"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u673a\u6784\u4fe1\u606f")
    public Flux<OrganizationEntity> getAllOrg() {
        return this.queryAll();
    }

    @PostMapping(value={"/_all"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u673a\u6784\u4fe1\u606f")
    public Flux<OrganizationEntity> getAllOrg(@RequestBody Mono<QueryParamEntity> query) {
        return this.queryAll(query);
    }

    @GetMapping(value={"/_query/_children/tree"})
    @QueryAction
    @QueryOperation(summary="\u67e5\u8be2\u673a\u6784\u5217\u8868(\u5305\u542b\u5b50\u673a\u6784)\u6811\u7ed3\u6784")
    public Mono<List<OrganizationEntity>> queryChildrenTree(@Parameter(hidden=true) QueryParamEntity entity) {
        return this.organizationService.queryIncludeChildrenTree(entity);
    }

    @GetMapping(value={"/_query/_children"})
    @QueryAction
    @QueryOperation(summary="\u67e5\u8be2\u673a\u6784\u5217\u8868(\u5305\u542b\u5b50\u673a\u6784)")
    public Flux<OrganizationEntity> queryChildren(@Parameter(hidden=true) QueryParamEntity entity) {
        return this.organizationService.queryIncludeChildren(entity);
    }

    @PostMapping(value={"/{id}/users/_bind"})
    @ResourceAction(id="bind-user", name="\u7ed1\u5b9a\u7528\u6237")
    @Operation(summary="\u7ed1\u5b9a\u7528\u6237\u5230\u673a\u6784")
    public Mono<Integer> bindUser(@Parameter(description="\u673a\u6784ID") @PathVariable String id, @Parameter(description="\u7528\u6237ID") @RequestBody Mono<List<String>> userId) {
        return userId.flatMap(list -> this.organizationService.bindUser(id, (List<String>)list));
    }

    @PostMapping(value={"/{id}/users/_unbind"})
    @ResourceAction(id="unbind-user", name="\u89e3\u7ed1\u7528\u6237")
    @Operation(summary="\u4ece\u673a\u6784\u89e3\u7ed1\u7528\u6237")
    public Mono<Integer> unbindUser(@Parameter(description="\u673a\u6784ID") @PathVariable String id, @Parameter(description="\u7528\u6237ID") @RequestBody Mono<List<String>> userId) {
        return userId.flatMap(list -> this.organizationService.unbindUser(id, (List<String>)list));
    }

    public ReactiveCrudService<OrganizationEntity, String> getService() {
        return this.organizationService;
    }
}

