/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.relation;

import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.jetlinks.community.auth.entity.ThirdPartyUserBindEntity;
import org.jetlinks.community.auth.entity.UserDetail;
import org.jetlinks.community.auth.service.UserDetailService;
import org.jetlinks.community.relation.RelationConstants;
import org.jetlinks.community.relation.RelationObjectProvider;
import org.jetlinks.community.relation.impl.SimpleObjectType;
import org.jetlinks.community.relation.impl.property.PropertyOperationStrategy;
import org.jetlinks.core.things.relation.ObjectType;
import org.jetlinks.core.things.relation.PropertyOperation;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class UserRelationObjectProvider
implements RelationObjectProvider {
    private final UserDetailService detailService;
    private final ReactiveRepository<ThirdPartyUserBindEntity, String> repository;

    public String getTypeId() {
        return "user";
    }

    public Mono<ObjectType> getType() {
        return Mono.just((Object)new SimpleObjectType(this.getTypeId(), "\u7528\u6237", "\u7cfb\u7edf\u7528\u6237"));
    }

    public PropertyOperation properties(String id) {
        return PropertyOperationStrategy.composite((PropertyOperationStrategy[])new PropertyOperationStrategy[]{PropertyOperationStrategy.simple((Mono)Mono.defer(() -> this.detailService.findUserDetail(id)).cache(), strategy -> {
            strategy.addMapper(RelationConstants.UserProperty.id, UserDetail::getId);
            strategy.addMapper(RelationConstants.UserProperty.name, UserDetail::getName);
            strategy.addMapper(RelationConstants.UserProperty.username, UserDetail::getUsername);
            strategy.addMapper(RelationConstants.UserProperty.email, UserDetail::getEmail);
            strategy.addMapper(RelationConstants.UserProperty.telephone, UserDetail::getTelephone);
            strategy.addMapper(RelationConstants.UserProperty.departments, UserDetail::getOrgIdList);
            strategy.addMapper(RelationConstants.UserProperty.roles, UserDetail::getRoleIdList);
            strategy.addMapper(RelationConstants.UserProperty.all, detail -> detail);
        }), PropertyOperationStrategy.detect(strategy -> strategy.addOperation("third", key -> {
            String[] typeAndProvider = key.split("[.]", 2);
            return ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.repository.createQuery().where(ThirdPartyUserBindEntity::getUserId, (Object)id)).and(ThirdPartyUserBindEntity::getType, (Object)typeAndProvider[0])).and(ThirdPartyUserBindEntity::getProvider, typeAndProvider.length == 2 ? typeAndProvider[1] : null)).fetch().map(ThirdPartyUserBindEntity::getThirdPartyUserId).singleOrEmpty().cast(Object.class);
        }))});
    }

    public UserRelationObjectProvider(UserDetailService detailService, ReactiveRepository<ThirdPartyUserBindEntity, String> repository) {
        this.detailService = detailService;
        this.repository = repository;
    }
}

