/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.timeseries.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.NamingConvention;
import java.util.HashMap;
import java.util.Map;
import org.jetlinks.community.micrometer.MeterRegistrySupplier;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesMetric;
import org.jetlinks.community.timeseries.micrometer.ElasticNamingConvention;
import org.jetlinks.community.timeseries.micrometer.TimeSeriesMeterRegistry;
import org.jetlinks.community.timeseries.micrometer.TimeSeriesRegistryProperties;

public class TimeSeriesMeterRegistrySupplier
implements MeterRegistrySupplier {
    private final TimeSeriesManager timeSeriesManager;
    private String naming = "elastic";
    static Map<String, NamingConvention> namingSupports = new HashMap<String, NamingConvention>();
    private Map<String, String> tags = new HashMap<String, String>();
    private Map<String, TimeSeriesRegistryProperties> metrics = new HashMap<String, TimeSeriesRegistryProperties>();

    public TimeSeriesMeterRegistrySupplier(TimeSeriesManager timeSeriesManager) {
        this.timeSeriesManager = timeSeriesManager;
        this.metrics.put("default", new TimeSeriesRegistryProperties());
    }

    public MeterRegistry getMeterRegistry(String metric, String ... tagKeys) {
        TimeSeriesMeterRegistry registry = new TimeSeriesMeterRegistry(this.timeSeriesManager, TimeSeriesMetric.of(metric), this.metrics.getOrDefault(metric, this.metrics.get("default")), this.tags, tagKeys);
        registry.config().namingConvention(namingSupports.get(this.naming));
        return registry;
    }

    public String getNaming() {
        return this.naming;
    }

    public void setNaming(String naming) {
        this.naming = naming;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Map<String, TimeSeriesRegistryProperties> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, TimeSeriesRegistryProperties> metrics) {
        this.metrics = metrics;
    }

    static {
        namingSupports.put("elastic", new ElasticNamingConvention());
    }
}

