/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.things.data.ThingsDataRepositoryStrategy;

public class ThingsDataRepositoryStrategies {
    private static final Map<String, ThingsDataRepositoryStrategy> strategyMap = new ConcurrentHashMap<String, ThingsDataRepositoryStrategy>();

    static void register(ThingsDataRepositoryStrategy strategy) {
        strategyMap.put(strategy.getId(), strategy);
    }

    public static List<ThingsDataRepositoryStrategy> getAll() {
        ArrayList<ThingsDataRepositoryStrategy> strategies = new ArrayList<ThingsDataRepositoryStrategy>(strategyMap.values());
        strategies.sort(Comparator.comparingLong(ThingsDataRepositoryStrategy::getOrder));
        return strategies;
    }

    public static Optional<ThingsDataRepositoryStrategy> getStrategy(String id) {
        return Optional.ofNullable(strategyMap.get(id));
    }
}

