/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import io.swagger.v3.oas.annotations.media.Schema;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.UnitSupported;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.unit.ValueUnit;
import org.jetlinks.core.things.ThingProperty;
import org.springframework.util.StringUtils;

@Generated
public class ThingPropertyDetail
implements ThingProperty {
    @Schema(description="ID")
    private String id;
    @Schema(description="\u7269\u5b9e\u4f8bID")
    private String thingId;
    @Schema(description="\u5c5e\u6027ID")
    private String property;
    @Schema(description="\u72b6\u6001")
    private String state;
    @Schema(description="\u5c5e\u6027\u503c")
    private Object value;
    @Schema(description="\u6570\u5b57\u503c")
    private Object numberValue;
    @Schema(description="\u683c\u5f0f\u5316\u540e\u7684\u503c")
    private Object formatValue;
    @Schema(description="\u5c5e\u6027\u540d")
    private String propertyName;
    @Schema(description="\u7c7b\u578b")
    private String type;
    @Schema(description="\u5355\u4f4d")
    private String unit;
    @Schema(description="\u65f6\u95f4\u6233")
    private long timestamp;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    private long createTime;
    @Schema(description="\u683c\u5f0f\u5316\u540e\u7684\u65f6\u95f4")
    private String formatTime;

    public ThingPropertyDetail property(String property) {
        this.property = property;
        return this;
    }

    public ThingPropertyDetail thingId(String thingId) {
        this.thingId = thingId;
        return this;
    }

    public ThingPropertyDetail timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ThingPropertyDetail createTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public ThingPropertyDetail formatTime(String formatTime) {
        this.formatTime = formatTime;
        return this;
    }

    public ThingPropertyDetail withProperty(PropertyMetadata metadata) {
        if (metadata != null) {
            this.setProperty(metadata.getId());
            this.setPropertyName(metadata.getName());
            DataType type = metadata.getValueType();
            Object value = this.getValue();
            try {
                if (type instanceof NumberType) {
                    NumberType numberType = (NumberType)type;
                    Number numberValue = (Number)NumberType.convertScaleNumber((Object)value, (Integer)numberType.getScale(), (RoundingMode)numberType.getRound(), Function.identity());
                    if (numberValue != null) {
                        value = numberValue;
                        this.setValue(value);
                    }
                    this.setNumberValue(numberValue);
                } else if (type instanceof Converter) {
                    value = ((Converter)type).convert(value);
                    this.setValue(value);
                }
                this.setFormatValue(type.format(value));
            }
            catch (Exception numberType) {
                // empty catch block
            }
            if (type instanceof UnitSupported) {
                UnitSupported unitSupported = (UnitSupported)type;
                this.setUnit(Optional.ofNullable(unitSupported.getUnit()).map(ValueUnit::getSymbol).orElse(null));
            }
            this.setType(type.getType());
        }
        return this;
    }

    public static ThingPropertyDetail of(TimeSeriesData data, Object value, PropertyMetadata metadata) {
        ThingPropertyDetail deviceProperty = (ThingPropertyDetail)data.as(ThingPropertyDetail.class);
        deviceProperty.setCreateTime(data.getLong("createTime", data.getTimestamp()));
        deviceProperty.setTimestamp(data.getTimestamp());
        deviceProperty.setValue(value);
        return deviceProperty.withProperty(metadata);
    }

    public static ThingPropertyDetail of(Object value, PropertyMetadata metadata) {
        ThingPropertyDetail property = new ThingPropertyDetail();
        property.setTimestamp(System.currentTimeMillis());
        property.setCreateTime(property.getTimestamp());
        property.setValue(value);
        return property.withProperty(metadata);
    }

    public static ThingPropertyDetail of(AggregationData data, PropertyMetadata metadata) {
        ThingPropertyDetail property = (ThingPropertyDetail)data.as(ThingPropertyDetail.class);
        return property.withProperty(metadata);
    }

    @Nullable
    public static ThingPropertyDetail of(TimeSeriesData timeSeriesData, PropertyMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        ThingPropertyDetail property = (ThingPropertyDetail)timeSeriesData.as(ThingPropertyDetail.class);
        property.setTimestamp(timeSeriesData.getTimestamp());
        return property.withProperty(metadata).generateId();
    }

    public ThingPropertyDetail generateId() {
        if (!StringUtils.hasText((String)this.id)) {
            this.setId(DigestUtils.md5Hex((String)String.join((CharSequence)"", this.thingId, this.property, String.valueOf(this.timestamp))));
        }
        return this;
    }

    public String toString() {
        return this.timestamp + " : " + this.property + " = " + this.value;
    }

    public String getId() {
        return this.id;
    }

    public String getThingId() {
        return this.thingId;
    }

    public String getProperty() {
        return this.property;
    }

    public String getState() {
        return this.state;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getNumberValue() {
        return this.numberValue;
    }

    public Object getFormatValue() {
        return this.formatValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getType() {
        return this.type;
    }

    public String getUnit() {
        return this.unit;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getFormatTime() {
        return this.formatTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setThingId(String thingId) {
        this.thingId = thingId;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setNumberValue(Object numberValue) {
        this.numberValue = numberValue;
    }

    public void setFormatValue(Object formatValue) {
        this.formatValue = formatValue;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setFormatTime(String formatTime) {
        this.formatTime = formatTime;
    }
}

