/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.utils;

import java.util.Map;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jetlinks.core.things.relation.ObjectSpec;
import org.jetlinks.reactor.ql.supports.DefaultPropertyFeature;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class VariableObjectSpec
extends ObjectSpec {
    private VariableSource objectSource;

    public void init(Map<String, Object> context) {
        if (this.objectSource != null) {
            switch (this.objectSource.getSource()) {
                case fixed: {
                    this.setObjectId((String)this.objectSource.getValue());
                }
                case upper: {
                    DefaultPropertyFeature.GLOBAL.getProperty((Object)this.objectSource.getUpperKey(), context).map(String::valueOf).ifPresent(arg_0 -> ((VariableObjectSpec)this).setObjectId(arg_0));
                }
            }
        }
    }

    public void validate() {
        Assert.hasText((String)this.getObjectType(), (String)"objectType can not be null");
        if (!StringUtils.hasText((String)this.getObjectId())) {
            Assert.notNull((Object)this.objectSource, (String)"objectSource can not be null");
            Assert.isTrue((this.objectSource.getSource() != VariableSource.Source.relation ? 1 : 0) != 0, (String)"unsupported source relation");
            this.objectSource.validate();
        }
    }

    public static VariableObjectSpec ofSource(String type, VariableSource object) {
        VariableObjectSpec spec = new VariableObjectSpec();
        spec.objectSource = object;
        spec.setObjectType(type);
        return spec;
    }

    public static VariableObjectSpec of(ObjectSpec object) {
        VariableObjectSpec spec = new VariableObjectSpec();
        spec.setObjectType(object.getObjectType());
        spec.setObjectId(object.getObjectId());
        spec.setRelated(object.getRelated());
        return spec;
    }

    public VariableSource getObjectSource() {
        return this.objectSource;
    }

    public void setObjectSource(VariableSource objectSource) {
        this.objectSource = objectSource;
    }
}

