/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.service;

import org.hswebframework.web.crud.events.EntityBeforeDeleteEvent;
import org.jetlinks.community.reference.DataReferenceManager;
import org.jetlinks.community.relation.entity.RelationEntity;
import org.reactivestreams.Publisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class RelationHandler {
    private final DataReferenceManager referenceManager;

    public RelationHandler(DataReferenceManager referenceManager) {
        this.referenceManager = referenceManager;
    }

    @EventListener
    public void handleRelationDeleted(EntityBeforeDeleteEvent<RelationEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(relation -> this.referenceManager.assertNotReferenced("relation", relation.getRelation())));
    }
}

