/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.CompositeMap;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.relation.ObjectType;
import org.jetlinks.core.things.relation.Relation;

public class CompositeObjectType
implements ObjectType {
    private final ObjectType main;
    private final ObjectType second;

    public List<PropertyMetadata> getProperties() {
        return Stream.concat(this.main.getProperties().stream(), this.second.getProperties().stream()).collect(Collectors.toList());
    }

    public List<Relation> getRelations(String type) {
        return Stream.concat(this.main.getRelations(type).stream(), this.second.getRelations(type).stream()).collect(Collectors.toList());
    }

    public List<ObjectType> getRelatedTypes() {
        return Stream.concat(this.main.getRelatedTypes().stream(), this.second.getRelatedTypes().stream()).collect(Collectors.toList());
    }

    public Map<String, List<Relation>> getRelations() {
        return new CompositeMap(this.main.getRelations(), this.second.getRelations());
    }

    public String getId() {
        return this.main.getId();
    }

    public String getName() {
        return this.main.getName();
    }

    public String getDescription() {
        return this.main.getDescription();
    }

    public Map<String, Object> getExpands() {
        HashMap<String, Object> expands = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty((Map)this.main.getExpands())) {
            expands.putAll(this.main.getExpands());
        }
        if (MapUtils.isNotEmpty((Map)this.second.getExpands())) {
            expands.putAll(this.second.getExpands());
        }
        return expands;
    }

    public CompositeObjectType(ObjectType main, ObjectType second) {
        this.main = main;
        this.second = second;
    }
}

