/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.protocol;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.supports.protocol.StaticProtocolSupports;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoader;
import org.jetlinks.supports.protocol.management.ProtocolSupportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
public class LazyInitManagementProtocolSupports
extends StaticProtocolSupports
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(LazyInitManagementProtocolSupports.class);
    private ProtocolSupportManager manager;
    private ProtocolSupportLoader loader;
    private ClusterManager clusterManager;
    private Map<String, String> configProtocolIdMapping = new ConcurrentHashMap<String, String>();
    private Duration loadTimeOut = Duration.ofSeconds(30L);

    public void init() {
        this.clusterManager.getTopic("_protocol_changed").subscribe().subscribe(protocol -> this.init((ProtocolSupportDefinition)protocol).subscribe());
        try {
            this.manager.loadAll().filter(de -> de.getState() == 1).flatMap(this::init).blockLast(this.loadTimeOut);
        }
        catch (Throwable e) {
            log.error("load protocol error", e);
        }
    }

    public Mono<Void> init(ProtocolSupportDefinition definition) {
        try {
            String protocol;
            if (definition.getState() != 1 && (protocol = this.configProtocolIdMapping.get(definition.getId())) != null) {
                log.debug("uninstall protocol:{}", (Object)definition);
                this.unRegister(protocol);
                return Mono.empty();
            }
            String operation = definition.getState() != 1 ? "uninstall" : "install";
            Consumer<ProtocolSupport> consumer = definition.getState() != 1 ? arg_0 -> ((LazyInitManagementProtocolSupports)this).unRegister(arg_0) : arg_0 -> ((LazyInitManagementProtocolSupports)this).register(arg_0);
            log.debug("{} protocol:{}", (Object)operation, (Object)definition);
            return this.loader.load(definition).doOnNext(e -> {
                e.init(definition.getConfiguration());
                log.debug("{} protocol[{}] success: {}", new Object[]{operation, definition.getId(), e});
                this.configProtocolIdMapping.put(definition.getId(), e.getId());
                consumer.accept((ProtocolSupport)e);
            }).onErrorResume(e -> {
                log.error("{} protocol[{}] error: {}", new Object[]{operation, definition.getId(), e});
                return Mono.empty();
            }).then();
        }
        catch (Throwable err) {
            log.error("init protocol error", err);
            return Mono.empty();
        }
    }

    public void run(String ... args) {
        this.init();
    }

    public ProtocolSupportManager getManager() {
        return this.manager;
    }

    public ProtocolSupportLoader getLoader() {
        return this.loader;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public Map<String, String> getConfigProtocolIdMapping() {
        return this.configProtocolIdMapping;
    }

    public Duration getLoadTimeOut() {
        return this.loadTimeOut;
    }

    public void setManager(ProtocolSupportManager manager) {
        this.manager = manager;
    }

    public void setLoader(ProtocolSupportLoader loader) {
        this.loader = loader;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setLoadTimeOut(Duration loadTimeOut) {
        this.loadTimeOut = loadTimeOut;
    }

    private void setConfigProtocolIdMapping(Map<String, String> configProtocolIdMapping) {
        this.configProtocolIdMapping = configProtocolIdMapping;
    }
}

