/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.sms.aliyun.web;

import io.swagger.v3.oas.annotations.Operation;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierManager;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.annotation.NotifierResource;
import org.jetlinks.community.notify.sms.aliyun.AliyunSmsNotifier;
import org.jetlinks.community.notify.sms.aliyun.expansion.SmsSign;
import org.jetlinks.community.notify.sms.aliyun.expansion.SmsTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/notifier/sms/aliyun"})
@NotifierResource
public class AliyunSmsController {
    private final NotifierManager notifierManager;

    @GetMapping(value={"/{configId}/signs"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u77ed\u4fe1\u6807\u7b7e\u5217\u8868")
    public Flux<SmsSign> getAliyunSmsSigns(@PathVariable String configId) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.sms, configId).filter(notifier -> notifier.isWrapperFor(AliyunSmsNotifier.class)).map(notifier -> (AliyunSmsNotifier)((Object)((Object)notifier.unwrap(AliyunSmsNotifier.class)))).flatMapMany(AliyunSmsNotifier::getSmsSigns);
    }

    @GetMapping(value={"/{configId}/templates"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u77ed\u4fe1\u6807\u7b7e\u5217\u8868")
    public Flux<SmsTemplate> getAliyunSmsTemplates(@PathVariable String configId) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.sms, configId).filter(notifier -> notifier.isWrapperFor(AliyunSmsNotifier.class)).map(notifier -> (AliyunSmsNotifier)((Object)((Object)notifier.unwrap(AliyunSmsNotifier.class)))).flatMapMany(AliyunSmsNotifier::getSmsTemplates);
    }

    public AliyunSmsController(NotifierManager notifierManager) {
        this.notifierManager = notifierManager;
    }
}

