/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.dingtalk.robot;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jetlinks.community.notify.template.AbstractTemplate;
import org.jetlinks.community.notify.template.Template;
import org.jetlinks.community.notify.template.VariableDefinition;
import org.springframework.util.Assert;

public class DingTalkWebHookTemplate
extends AbstractTemplate<DingTalkWebHookTemplate> {
    private MessageType messageType;
    private Text text;
    private Markdown markdown;
    private Link link;
    private At at;

    public DingTalkWebHookTemplate validate() {
        Assert.notNull((Object)((Object)this.messageType), (String)"messageType can not be null");
        switch (this.messageType) {
            case text: {
                Assert.notNull((Object)this.text, (String)"text can not be null");
                break;
            }
            case markdown: {
                Assert.notNull((Object)this.markdown, (String)"markdown can not be null");
                break;
            }
            case link: {
                Assert.notNull((Object)this.link, (String)"link can not be null");
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported messageType " + (Object)((Object)this.messageType));
            }
        }
        return this;
    }

    public JSONObject toJson(Map<String, Object> context) {
        this.validate();
        JSONObject json = new JSONObject();
        json.put("msgtype", (Object)this.messageType.name());
        if (this.at != null) {
            json.put("at", (Object)this.at.render((Template)this, context).toJson());
        }
        switch (this.messageType) {
            case text: {
                json.put("text", (Object)this.text.render((Template)this, context).toJson());
                break;
            }
            case markdown: {
                json.put("markdown", (Object)this.markdown.render((Template)this, context).toJson());
                break;
            }
            case link: {
                json.put("link", (Object)this.link.render((Template)this, context).toJson());
            }
        }
        return json;
    }

    @Nonnull
    protected List<VariableDefinition> getEmbeddedVariables() {
        if (MessageType.link.equals((Object)this.getMessageType())) {
            Link link = this.getLink();
            if (link == null) {
                return super.getEmbeddedVariables();
            }
            ArrayList<VariableDefinition> variableDefinitions = new ArrayList<VariableDefinition>(2);
            if (StringUtils.isEmpty((CharSequence)link.getMessageUrl())) {
                variableDefinitions.add(VariableDefinition.builder().id("messageUrl").name("\u5185\u5bb9\u94fe\u63a5").description("\u5185\u5bb9\u6d88\u606f\u94fe\u63a5").expand("businessType", (Object)"link").type("string").required(true).build());
            }
            if (StringUtils.isEmpty((CharSequence)link.getPicUrl())) {
                variableDefinitions.add(VariableDefinition.builder().id("picUrl").name("\u56fe\u7247\u94fe\u63a5").description("\u56fe\u7247\u94fe\u63a5").expand("businessType", (Object)"file").type("string").required(true).build());
            }
            return variableDefinitions;
        }
        return super.getEmbeddedVariables();
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Text getText() {
        return this.text;
    }

    public Markdown getMarkdown() {
        return this.markdown;
    }

    public Link getLink() {
        return this.link;
    }

    public At getAt() {
        return this.at;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public void setMarkdown(Markdown markdown) {
        this.markdown = markdown;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public void setAt(At at) {
        this.at = at;
    }

    public static class Link {
        public static final String MESSAGE_URL_KEY = "messageUrl";
        public static final String PIC_URL_KEY = "picUrl";
        private String title;
        private String picUrl;
        private String text;
        private String messageUrl;

        public Link render(Template template, Map<String, Object> context) {
            return new Link(template.render(this.title, context), template.get((Object)this.picUrl, PIC_URL_KEY, context), template.render(this.text, context), template.get((Object)this.getMessageUrl(), MESSAGE_URL_KEY, context));
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            json.put("title", (Object)this.title);
            json.put("text", (Object)this.text);
            json.put(PIC_URL_KEY, (Object)this.picUrl);
            json.put(MESSAGE_URL_KEY, (Object)this.messageUrl);
            return json;
        }

        public String getTitle() {
            return this.title;
        }

        public String getPicUrl() {
            return this.picUrl;
        }

        public String getText() {
            return this.text;
        }

        public String getMessageUrl() {
            return this.messageUrl;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setPicUrl(String picUrl) {
            this.picUrl = picUrl;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setMessageUrl(String messageUrl) {
            this.messageUrl = messageUrl;
        }

        public Link(String title, String picUrl, String text, String messageUrl) {
            this.title = title;
            this.picUrl = picUrl;
            this.text = text;
            this.messageUrl = messageUrl;
        }

        public Link() {
        }
    }

    public static class Markdown {
        private String title;
        private String text;

        public Markdown render(Template template, Map<String, Object> context) {
            return new Markdown(template.render(this.title, context), template.render(this.text, context));
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            json.put("title", (Object)this.title);
            json.put("text", (Object)this.text);
            return json;
        }

        public String getTitle() {
            return this.title;
        }

        public String getText() {
            return this.text;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Markdown(String title, String text) {
            this.title = title;
            this.text = text;
        }

        public Markdown() {
        }
    }

    public static class Text {
        private String content;

        public Text render(Template template, Map<String, Object> context) {
            return new Text(template.render(this.content, context));
        }

        public JSONObject toJson() {
            return new JSONObject(Collections.singletonMap("content", this.content));
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public Text(String content) {
            this.content = content;
        }

        public Text() {
        }
    }

    public static class At {
        private List<String> atMobiles;
        private List<String> atUserIds;
        private boolean atAll;

        public At render(Template template, Map<String, Object> context) {
            return new At(template.render(this.atMobiles, context), template.render(this.atUserIds, context), this.atAll);
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            json.put("atMobiles", this.atMobiles);
            json.put("atUserIds", this.atUserIds);
            json.put("isAtAll", (Object)this.atAll);
            return json;
        }

        public List<String> getAtMobiles() {
            return this.atMobiles;
        }

        public List<String> getAtUserIds() {
            return this.atUserIds;
        }

        public boolean isAtAll() {
            return this.atAll;
        }

        public void setAtMobiles(List<String> atMobiles) {
            this.atMobiles = atMobiles;
        }

        public void setAtUserIds(List<String> atUserIds) {
            this.atUserIds = atUserIds;
        }

        public void setAtAll(boolean atAll) {
            this.atAll = atAll;
        }

        public At(List<String> atMobiles, List<String> atUserIds, boolean atAll) {
            this.atMobiles = atMobiles;
            this.atUserIds = atUserIds;
            this.atAll = atAll;
        }

        public At() {
        }
    }

    public static enum MessageType {
        text,
        link,
        markdown;

    }
}

