/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.parser.strateies;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.parsetools.RecordParser;
import java.util.function.Supplier;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.network.tcp.parser.PayloadParser;
import org.jetlinks.community.network.tcp.parser.PayloadParserBuilderStrategy;
import org.jetlinks.community.network.tcp.parser.PayloadParserType;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public abstract class VertxPayloadParserBuilder
implements PayloadParserBuilderStrategy {
    @Override
    public abstract PayloadParserType getType();

    protected abstract Supplier<RecordParser> createParser(ValueObject var1);

    @Override
    public Supplier<PayloadParser> buildLazy(ValueObject config) {
        Supplier<RecordParser> parser = this.createParser(config);
        return () -> new RecordPayloadParser(parser);
    }

    static class RecordPayloadParser
    implements PayloadParser {
        private final Supplier<RecordParser> recordParserSupplier;
        private final Sinks.Many<Buffer> sink = Reactors.createMany();
        private RecordParser recordParser;

        public RecordPayloadParser(Supplier<RecordParser> recordParserSupplier) {
            this.recordParserSupplier = recordParserSupplier;
            this.reset();
        }

        @Override
        public void handle(Buffer buffer) {
            this.recordParser.handle(buffer);
        }

        @Override
        public Flux<Buffer> handlePayload() {
            return this.sink.asFlux();
        }

        @Override
        public void close() {
            this.sink.emitComplete(Reactors.emitFailureHandler());
        }

        @Override
        public void reset() {
            this.recordParser = this.recordParserSupplier.get();
            this.recordParser.handler(payload -> this.sink.emitNext(payload, Reactors.emitFailureHandler()));
        }
    }
}

