/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.mqtt.gateway.device.session;

import java.time.Duration;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;
import org.jetlinks.community.network.mqtt.client.MqttClient;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.publisher.Mono;

public class MqttClientSession
implements DeviceSession {
    private final String id;
    private final DeviceOperator operator;
    private MqttClient client;
    private final long connectTime = System.currentTimeMillis();
    private long lastPingTime = System.currentTimeMillis();
    private long keepAliveTimeout = -1L;
    private final DeviceGatewayMonitor monitor;

    public MqttClientSession(String id, DeviceOperator operator, MqttClient client, DeviceGatewayMonitor monitor) {
        this.id = id;
        this.operator = operator;
        this.client = client;
        this.monitor = monitor;
    }

    public String getDeviceId() {
        return this.operator.getDeviceId();
    }

    public long lastPingTime() {
        return this.lastPingTime;
    }

    public long connectTime() {
        return this.connectTime;
    }

    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        if (encodedMessage instanceof MqttMessage) {
            this.monitor.sentMessage();
            return this.client.publish((MqttMessage)encodedMessage).thenReturn((Object)true);
        }
        return Mono.error((Throwable)new UnsupportedOperationException("unsupported message type:" + encodedMessage.getClass()));
    }

    public Transport getTransport() {
        return DefaultTransport.MQTT;
    }

    public void close() {
    }

    public void ping() {
        this.lastPingTime = System.currentTimeMillis();
    }

    public boolean isAlive() {
        return this.client.isAlive() && (this.keepAliveTimeout <= 0L || System.currentTimeMillis() - this.lastPingTime < this.keepAliveTimeout);
    }

    public void onClose(Runnable call) {
    }

    public void setKeepAliveTimeout(Duration timeout) {
        this.keepAliveTimeout = timeout.toMillis();
    }

    public String toString() {
        return "MqttClientSession{id=" + this.id + ",device=" + this.getDeviceId() + '}';
    }

    public String getId() {
        return this.id;
    }

    public DeviceOperator getOperator() {
        return this.operator;
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }
}

