/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.mqtt.gateway.device;

import java.util.Objects;
import org.jetlinks.community.gateway.DeviceGateway;
import org.jetlinks.community.gateway.supports.DeviceGatewayProperties;
import org.jetlinks.community.gateway.supports.DeviceGatewayProvider;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.mqtt.client.MqttClient;
import org.jetlinks.community.network.mqtt.gateway.device.MqttClientDeviceGateway;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.supports.server.DecodedClientMessageHandler;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class MqttClientDeviceGatewayProvider
implements DeviceGatewayProvider {
    private final NetworkManager networkManager;
    private final DeviceRegistry registry;
    private final DeviceSessionManager sessionManager;
    private final DecodedClientMessageHandler clientMessageHandler;
    private final ProtocolSupports protocolSupports;

    public MqttClientDeviceGatewayProvider(NetworkManager networkManager, DeviceRegistry registry, DeviceSessionManager sessionManager, DecodedClientMessageHandler clientMessageHandler, ProtocolSupports protocolSupports) {
        this.networkManager = networkManager;
        this.registry = registry;
        this.sessionManager = sessionManager;
        this.clientMessageHandler = clientMessageHandler;
        this.protocolSupports = protocolSupports;
    }

    public String getId() {
        return "mqtt-client-gateway";
    }

    public String getName() {
        return "MQTT Broker\u63a5\u5165";
    }

    public NetworkType getNetworkType() {
        return DefaultNetworkType.MQTT_CLIENT;
    }

    public Transport getTransport() {
        return DefaultTransport.MQTT;
    }

    public Mono<DeviceGateway> createDeviceGateway(DeviceGatewayProperties properties) {
        return this.networkManager.getNetwork(this.getNetworkType(), properties.getChannelId()).map(mqttClient -> {
            String protocol = properties.getProtocol();
            return new MqttClientDeviceGateway(properties.getId(), (MqttClient)mqttClient, this.registry, (Mono<ProtocolSupport>)Mono.defer(() -> this.protocolSupports.getProtocol(protocol)), this.sessionManager, this.clientMessageHandler);
        });
    }

    public Mono<? extends DeviceGateway> reloadDeviceGateway(DeviceGateway gateway, DeviceGatewayProperties properties) {
        MqttClientDeviceGateway deviceGateway = (MqttClientDeviceGateway)gateway;
        String networkId = properties.getChannelId();
        if (!Objects.equals(networkId, deviceGateway.mqttClient.getId())) {
            return gateway.shutdown().then(this.createDeviceGateway(properties).flatMap(gate -> gate.startup().thenReturn(gate)));
        }
        deviceGateway.setProtocol((Mono<ProtocolSupport>)this.protocolSupports.getProtocol(properties.getProtocol()));
        return deviceGateway.reload().thenReturn((Object)deviceGateway);
    }
}

