/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.mqtt.client;

import io.vertx.core.Vertx;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.Network;
import org.jetlinks.community.network.NetworkProperties;
import org.jetlinks.community.network.NetworkProvider;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.mqtt.client.MqttClientProperties;
import org.jetlinks.community.network.mqtt.client.VertxMqttClient;
import org.jetlinks.community.network.security.CertificateManager;
import org.jetlinks.community.network.security.VertxKeyCertTrustOptions;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class MqttClientProvider
implements NetworkProvider<MqttClientProperties> {
    private static final Logger log = LoggerFactory.getLogger(MqttClientProvider.class);
    private final Vertx vertx;
    private final CertificateManager certificateManager;
    private final Environment environment;

    public MqttClientProvider(CertificateManager certificateManager, Vertx vertx, Environment environment) {
        this.vertx = vertx;
        this.certificateManager = certificateManager;
        this.environment = environment;
    }

    @Nonnull
    public NetworkType getType() {
        return DefaultNetworkType.MQTT_CLIENT;
    }

    @Nonnull
    public Mono<Network> createNetwork(@Nonnull MqttClientProperties properties) {
        VertxMqttClient mqttClient = new VertxMqttClient(properties.getId());
        return this.initMqttClient(mqttClient, properties);
    }

    public Mono<Network> reload(@Nonnull Network network, @Nonnull MqttClientProperties properties) {
        VertxMqttClient mqttClient = (VertxMqttClient)network;
        if (mqttClient.isLoading()) {
            return Mono.just((Object)mqttClient);
        }
        return this.initMqttClient(mqttClient, properties);
    }

    public Mono<Network> initMqttClient(VertxMqttClient mqttClient, MqttClientProperties properties) {
        return this.convert(properties).map(options -> {
            mqttClient.setTopicPrefix(properties.getTopicPrefix());
            mqttClient.setLoading(true);
            MqttClient client = MqttClient.create((Vertx)this.vertx, (MqttClientOptions)options);
            mqttClient.setClient(client);
            client.connect(properties.getRemotePort(), properties.getRemoteHost(), result -> {
                mqttClient.setLoading(false);
                if (!result.succeeded()) {
                    log.warn("connect mqtt [{}@{}:{}] error", new Object[]{properties.getClientId(), properties.getRemoteHost(), properties.getRemotePort(), result.cause()});
                } else {
                    log.debug("connect mqtt [{}] success", (Object)properties.getId());
                }
            });
            return mqttClient;
        });
    }

    @Nullable
    public ConfigMetadata getConfigMetadata() {
        return new DefaultConfigMetadata().add("id", "id", "", (DataType)new StringType()).add("remoteHost", "\u8fdc\u7a0b\u5730\u5740", "", (DataType)new StringType()).add("remotePort", "\u8fdc\u7a0b\u5730\u5740", "", (DataType)new IntType()).add("certId", "\u8bc1\u4e66id", "", (DataType)new StringType()).add("secure", "\u5f00\u542fTSL", "", (DataType)new BooleanType()).add("clientId", "\u5ba2\u6237\u7aefID", "", (DataType)new BooleanType()).add("username", "\u7528\u6237\u540d", "", (DataType)new BooleanType()).add("password", "\u5bc6\u7801", "", (DataType)new BooleanType());
    }

    @Nonnull
    public Mono<MqttClientProperties> createConfig(@Nonnull NetworkProperties properties) {
        return (Mono)Mono.defer(() -> {
            MqttClientProperties config = (MqttClientProperties)((Object)((Object)FastBeanCopier.copy((Object)properties.getConfigurations(), (Object)((Object)new MqttClientProperties()), (String[])new String[0])));
            config.setId(properties.getId());
            config.validate();
            return Mono.just((Object)((Object)config));
        }).as(LocaleUtils::transform);
    }

    private Mono<MqttClientOptions> convert(MqttClientProperties config) {
        MqttClientOptions options = (MqttClientOptions)FastBeanCopier.copy((Object)((Object)config), MqttClientOptions.class, (String[])new String[0]);
        options.setTcpKeepAlive(true);
        options.setAutoKeepAlive(true);
        options.setKeepAliveInterval(180);
        String clientId = String.valueOf(config.getClientId());
        String username = config.getUsername();
        String password = config.getPassword();
        options.setClientId(clientId);
        options.setPassword(password);
        options.setUsername(username);
        if (config.isSecure()) {
            options.setSsl(true);
            return this.certificateManager.getCertificate(config.getCertId()).map(VertxKeyCertTrustOptions::new).doOnNext(arg_0 -> ((MqttClientOptions)options).setKeyCertOptions(arg_0)).doOnNext(arg_0 -> ((MqttClientOptions)options).setTrustOptions(arg_0)).thenReturn((Object)options);
        }
        return Mono.just((Object)options);
    }
}

