/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.server.vertx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.SocketAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetlinks.community.network.http.DefaultHttpRequestMessage;
import org.jetlinks.community.network.http.VertxWebUtils;
import org.jetlinks.community.network.http.server.HttpExchange;
import org.jetlinks.community.network.http.server.HttpRequest;
import org.jetlinks.community.network.http.server.HttpResponse;
import org.jetlinks.community.network.http.server.vertx.HttpServerConfig;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpRequestMessage;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class VertxHttpExchange
implements HttpExchange,
HttpResponse,
HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(VertxHttpExchange.class);
    static final AtomicReferenceFieldUpdater<VertxHttpExchange, Boolean> ALREADY_RESPONSE = AtomicReferenceFieldUpdater.newUpdater(VertxHttpExchange.class, Boolean.class, "alreadyResponse");
    static final MultiPart emptyPart = MultiPart.of(Collections.emptyList());
    private final HttpServerRequest httpServerRequest;
    private final HttpServerResponse response;
    private final Mono<ByteBuf> body;
    private final String requestId;
    private MultiPart multiPart;
    private volatile Boolean alreadyResponse = false;

    public VertxHttpExchange(HttpServerRequest httpServerRequest, HttpServerConfig config) {
        this.httpServerRequest = httpServerRequest;
        this.response = httpServerRequest.response();
        this.requestId = UUID.randomUUID().toString();
        config.getHttpHeaders().forEach((arg_0, arg_1) -> ((HttpServerResponse)this.response).putHeader(arg_0, arg_1));
        if (httpServerRequest.method() == io.vertx.core.http.HttpMethod.GET) {
            this.body = Mono.just((Object)Unpooled.EMPTY_BUFFER);
        } else {
            Mono buffer = Mono.fromCompletionStage((CompletionStage)this.httpServerRequest.body().toCompletionStage()).map(Buffer::getByteBuf);
            this.body = MultiPart.isMultiPart((MediaType)this.getContentType()) ? MultiPart.parse((HttpHeaders)this.getSpringHttpHeaders(), (Flux)buffer.flux()).doOnNext(this::setMultiPart).thenReturn((Object)Unpooled.EMPTY_BUFFER).cache() : buffer;
        }
    }

    @Override
    @Generated
    public String requestId() {
        return this.requestId;
    }

    @Override
    @Generated
    public long timestamp() {
        return System.currentTimeMillis();
    }

    @Override
    @Generated
    public HttpRequest request() {
        return this;
    }

    @Override
    @Generated
    public HttpResponse response() {
        return this;
    }

    @Override
    @Generated
    public boolean isClosed() {
        return this.response.closed() || this.response.ended();
    }

    @Override
    @Generated
    public HttpResponse status(int status) {
        this.response.setStatusCode(status);
        return this;
    }

    static Map<String, String> convertRequestParam(MultiMap multiMap) {
        return multiMap.entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> String.join((CharSequence)",", a, b)));
    }

    static List<Header> convertHeader(MultiMap multiMap) {
        return multiMap.names().stream().map(name -> {
            Header header = new Header();
            header.setName(name);
            header.setValue(multiMap.getAll(name).toArray(new String[0]));
            return header;
        }).collect(Collectors.toList());
    }

    private HttpMethod convertMethodType(io.vertx.core.http.HttpMethod method) {
        for (HttpMethod httpMethod : HttpMethod.values()) {
            if (!httpMethod.toString().equals(method.toString())) continue;
            return httpMethod;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684HttpMethod\u7c7b\u578b: " + method);
    }

    private void setResponseDefaultLength(int length) {
        if (!this.isClosed()) {
            this.response.putHeader("Content-Length", String.valueOf(length));
        }
    }

    @Override
    public HttpResponse contentType(MediaType mediaType) {
        if (null != mediaType && !this.isClosed()) {
            this.response.putHeader("Content-Type", mediaType.toString());
        }
        return this;
    }

    @Override
    public HttpResponse header(Header header) {
        if (null != header && !this.isClosed()) {
            this.response.putHeader(header.getName(), Arrays.asList(header.getValue()));
        }
        return this;
    }

    @Override
    public HttpResponse header(String header, String value) {
        if (header != null && value != null && !this.isClosed()) {
            this.response.putHeader(header, value);
        }
        return this;
    }

    @Override
    public Mono<Void> write(ByteBuf buffer) {
        if (this.isClosed()) {
            return Mono.empty();
        }
        return Mono.create(sink -> {
            Buffer buf = Buffer.buffer((ByteBuf)buffer);
            this.setResponseDefaultLength(buf.length());
            this.response.write((Object)buf, v -> {
                sink.success();
                if (!(buffer instanceof UnpooledHeapByteBuf)) {
                    ReferenceCountUtil.safeRelease((Object)buffer);
                }
            });
        });
    }

    @Override
    public Mono<Void> end() {
        if (this.isClosed()) {
            return Mono.empty();
        }
        ALREADY_RESPONSE.set(this, true);
        return Mono.create(sink -> {
            if (this.response.ended()) {
                sink.success();
                return;
            }
            this.response.end(v -> sink.success());
        });
    }

    @Override
    public Mono<Void> response(HttpResponseMessage message) {
        if (ALREADY_RESPONSE.compareAndSet(this, false, true)) {
            return HttpExchange.super.response(message);
        }
        if (log.isInfoEnabled()) {
            log.info("http already response,discard message: {}", (Object)message.print());
        }
        return Mono.empty();
    }

    @Override
    @Generated
    public String getUrl() {
        return this.httpServerRequest.path();
    }

    @Override
    @Generated
    public String getPath() {
        return this.httpServerRequest.path();
    }

    @Override
    @Generated
    public String getRemoteIp() {
        return this.httpServerRequest.remoteAddress().host();
    }

    @Override
    @Generated
    public String getRealIp() {
        return VertxWebUtils.getIpAddr(this.httpServerRequest);
    }

    @Override
    public InetSocketAddress getClientAddress() {
        SocketAddress address = this.httpServerRequest.remoteAddress();
        if (null == address) {
            return null;
        }
        return new InetSocketAddress(this.getRealIp(), address.port());
    }

    @Override
    public MediaType getContentType() {
        String contentType = this.httpServerRequest.getHeader("Content-Type");
        if (StringUtils.hasText((String)contentType)) {
            return MediaType.parseMediaType((String)contentType);
        }
        return MediaType.APPLICATION_FORM_URLENCODED;
    }

    @Override
    public Optional<String> getQueryParameter(String key) {
        return Optional.ofNullable(this.httpServerRequest.getParam(key));
    }

    @Override
    public Map<String, String> getQueryParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        MultiMap map = this.httpServerRequest.params();
        for (String name : map.names()) {
            params.put(name, String.join((CharSequence)",", map.getAll(name)));
        }
        return params;
    }

    @Override
    @Generated
    public Map<String, String> getRequestParam() {
        return VertxHttpExchange.convertRequestParam(this.httpServerRequest.formAttributes());
    }

    @Override
    @Generated
    public Mono<ByteBuf> getBody() {
        return this.body;
    }

    @Override
    @Generated
    public HttpMethod getMethod() {
        return this.convertMethodType(this.httpServerRequest.method());
    }

    @Override
    @Generated
    public List<Header> getHeaders() {
        return VertxHttpExchange.convertHeader(this.httpServerRequest.headers());
    }

    private HttpHeaders getSpringHttpHeaders() {
        MultiMap map = this.httpServerRequest.headers();
        HttpHeaders headers = new HttpHeaders();
        for (String name : map.names()) {
            headers.addAll(name, map.getAll(name));
        }
        return headers;
    }

    @Override
    public Optional<Header> getHeader(String key) {
        return Optional.ofNullable(this.getHeaders().stream().collect(Collectors.toMap(Header::getName, Function.identity())).get(key));
    }

    @Override
    public Mono<HttpRequestMessage> toMessage() {
        return this.getBody().defaultIfEmpty((Object)Unpooled.EMPTY_BUFFER).map(byteBuf -> {
            DefaultHttpRequestMessage message = new DefaultHttpRequestMessage();
            message.setContentType(this.getContentType());
            message.setHeaders(this.getHeaders());
            message.setMethod(this.getMethod());
            message.setPayload((ByteBuf)byteBuf);
            message.setQueryParameters(this.getQueryParameters());
            message.setUrl(this.getUrl());
            message.setMultiPart(this.multiPart);
            return message;
        });
    }

    @Override
    public Mono<MultiPart> multiPart() {
        return this.body.then(Mono.fromSupplier(this::getMultiPart)).defaultIfEmpty((Object)emptyPart);
    }

    public HttpServerRequest getHttpServerRequest() {
        return this.httpServerRequest;
    }

    public HttpServerResponse getResponse() {
        return this.response;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public MultiPart getMultiPart() {
        return this.multiPart;
    }

    public Boolean getAlreadyResponse() {
        return this.alreadyResponse;
    }

    public void setMultiPart(MultiPart multiPart) {
        this.multiPart = multiPart;
    }

    public void setAlreadyResponse(Boolean alreadyResponse) {
        this.alreadyResponse = alreadyResponse;
    }
}

