/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.logging.access;

import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.logging.AccessLoggerInfo;
import org.springframework.http.codec.multipart.FilePart;

public class SerializableAccessLog
implements Serializable {
    @Schema(description="\u65e5\u5fd7ID")
    private String id;
    @Schema(description="\u64cd\u4f5c")
    private String action;
    @Schema(description="\u63cf\u8ff0")
    private String describe;
    @Schema(description="\u8bf7\u6c42\u65b9\u6cd5\u540d")
    private String method;
    @Schema(description="\u8bf7\u6c42\u7c7b")
    private String target;
    @Schema(description="\u8bf7\u6c42\u53c2\u6570")
    private Map<String, Object> parameters;
    @Schema(description="\u8bf7\u6c42\u4e2dIP")
    private String ip;
    @Schema(description="\u8bf7\u6c42\u5730\u5740")
    private String url;
    @Schema(description="\u8bf7\u6c42\u5934")
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    @Schema(description="\u4e0a\u4e0b\u6587")
    private Map<String, String> context = new HashMap<String, String>();
    @Schema(description="\u8bf7\u6c42\u65b9\u6cd5")
    private String httpMethod;
    @Schema(description="\u8bf7\u6c42\u65f6\u95f4")
    private long requestTime;
    @Schema(description="\u54cd\u5e94\u65f6\u95f4")
    private long responseTime;
    @Schema(description="\u5f02\u5e38\u6808\u4fe1\u606f")
    private String exception;

    public static SerializableAccessLog of(AccessLoggerInfo info) {
        SerializableAccessLog accessLog = (SerializableAccessLog)FastBeanCopier.copy((Object)info, (Object)new SerializableAccessLog(), (String[])new String[]{"parameters", "method", "target", "exception"});
        accessLog.setMethod(info.getMethod().getName());
        accessLog.setTarget(info.getTarget().getName());
        accessLog.getHttpHeaders().remove("X_Access_Token");
        accessLog.getHttpHeaders().remove("Authorization");
        accessLog.setException(info.getException() == null ? "" : StringUtils.throwable2String((Throwable)info.getException()));
        Map<String, Object> newParameter = info.getParameters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Object value = e.getValue();
            if (value instanceof FilePart) {
                return "file:" + ((FilePart)value).filename();
            }
            String className = value.getClass().getName();
            if (className.startsWith("org.springframework")) {
                return className;
            }
            return JSON.toJSONString(value);
        }));
        accessLog.setParameters(newParameter);
        return accessLog;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public String getId() {
        return this.id;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getMethod() {
        return this.method;
    }

    public String getTarget() {
        return this.target;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public String getException() {
        return this.exception;
    }
}

