/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.io.excel;

import java.io.FileInputStream;
import java.io.InputStream;
import org.hswebframework.reactor.excel.ReactorExcel;
import org.hswebframework.reactor.excel.converter.RowWrapper;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.community.io.excel.ImportExportService;
import org.jetlinks.community.io.excel.RowResult;
import org.jetlinks.community.io.excel.easyexcel.ExcelReadDataListener;
import org.jetlinks.community.io.file.FileInfo;
import org.jetlinks.community.io.file.FileManager;
import org.jetlinks.community.io.utils.FileUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DefaultImportExportService
implements ImportExportService {
    private WebClient client;
    private final FileManager fileManager;

    public DefaultImportExportService(WebClient.Builder builder, FileManager fileManager) {
        this.client = builder.build();
        this.fileManager = fileManager;
    }

    @Override
    public <T> Flux<RowResult<T>> doImport(Class<T> clazz, String fileUrl) {
        return this.getInputStream(fileUrl).flatMapMany(inputStream -> ExcelReadDataListener.of(inputStream, clazz));
    }

    @Override
    public <T> Flux<RowResult<T>> doImport(Class<T> clazz, InputStream stream) {
        return ExcelReadDataListener.of(stream, clazz);
    }

    @Override
    public <T> Flux<T> readData(String fileUrl, String fileId, RowWrapper<T> wrapper) {
        if (!StringUtils.isNullOrEmpty((Object)fileUrl)) {
            return this.getInputStream(fileUrl).flatMapMany(inputStream -> ReactorExcel.read((InputStream)inputStream, (String)FileUtils.getExtension(fileUrl), (RowWrapper)wrapper));
        }
        return Mono.zip((Mono)((Mono)this.fileManager.read(fileId).as(DataBufferUtils::join)).map(DataBuffer::asInputStream), this.fileManager.getFile(fileId)).flatMapMany(t2 -> ReactorExcel.read((InputStream)((InputStream)t2.getT1()), (String)((FileInfo)t2.getT2()).getExtension(), (RowWrapper)wrapper));
    }

    @Override
    public Mono<InputStream> getInputStream(String fileUrl) {
        return Mono.defer(() -> {
            if (fileUrl.startsWith("http")) {
                return this.client.get().uri(fileUrl, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM}).exchange().flatMap(clientResponse -> clientResponse.bodyToMono(Resource.class)).flatMap(resource -> Mono.fromCallable(() -> ((Resource)resource).getInputStream()));
            }
            return Mono.fromCallable(() -> new FileInputStream(fileUrl));
        });
    }
}

