/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Sort;
import org.hswebframework.ezorm.core.param.Term;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.parser.DefaultLinkTypeParser;
import org.jetlinks.community.utils.ConverterUtils;
import org.jetlinks.community.utils.TimeUtils;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryParamTranslator {
    private static final Logger log = LoggerFactory.getLogger(QueryParamTranslator.class);
    static DefaultLinkTypeParser linkTypeParser = new DefaultLinkTypeParser();
    static Consumer<Term> doNotingParamConverter = term -> {};
    static Map<String, BiConsumer<DataType, Term>> converter = new ConcurrentHashMap<String, BiConsumer<DataType, Term>>();
    static BiConsumer<DataType, Term> defaultDataTypeConverter = (type, term) -> {};

    public static QueryBuilder createQueryBuilder(QueryParam queryParam, ElasticSearchIndexMetadata metadata) {
        BoolQueryBuilder queryBuilders = QueryBuilders.boolQuery();
        Consumer<Term> paramConverter = doNotingParamConverter;
        if (metadata != null) {
            paramConverter = t -> {
                if (ObjectUtils.isEmpty((Object)t.getColumn())) {
                    return;
                }
                PropertyMetadata property = metadata.getProperty(t.getColumn());
                if (null != property) {
                    DataType type = property.getValueType();
                    t.setValue(ConverterUtils.tryConvertToList((Object)t.getValue(), val -> {
                        if (type instanceof DateTimeType) {
                            return TimeUtils.convertToDate((Object)val).getTime();
                        }
                        if (type instanceof Converter) {
                            return ((Converter)type).convert(val);
                        }
                        return val;
                    }));
                    converter.getOrDefault(type.getId(), defaultDataTypeConverter).accept(type, (Term)t);
                }
            };
        }
        for (Term term : queryParam.getTerms()) {
            linkTypeParser.process(term, paramConverter, queryBuilders);
        }
        return queryBuilders;
    }

    public static SearchSourceBuilder convertSearchSourceBuilder(QueryParam queryParam, ElasticSearchIndexMetadata metadata) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (queryParam.isPaging()) {
            sourceBuilder.from(queryParam.getPageIndex() * queryParam.getPageSize());
            sourceBuilder.size(queryParam.getPageSize());
        }
        for (Sort sort : queryParam.getSorts()) {
            if (StringUtils.isEmpty((Object)sort.getName())) continue;
            sourceBuilder.sort(sort.getName(), SortOrder.fromString((String)sort.getOrder()));
        }
        return sourceBuilder.query(QueryParamTranslator.createQueryBuilder(queryParam, metadata));
    }
}

