/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.index;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.Generated;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import reactor.core.publisher.Mono;

@ConfigurationProperties(prefix="elasticsearch.index")
public class DefaultElasticSearchIndexManager
implements ElasticSearchIndexManager {
    @Generated
    private String defaultStrategy = "direct";
    @Generated
    private Map<String, String> indexUseStrategy = new ConcurrentSkipListMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ElasticSearchIndexStrategy> strategies = new ConcurrentSkipListMap<String, ElasticSearchIndexStrategy>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ElasticSearchIndexMetadata> indexMetadataStore = new ConcurrentSkipListMap<String, ElasticSearchIndexMetadata>(String.CASE_INSENSITIVE_ORDER);

    public DefaultElasticSearchIndexManager(@Autowired(required=false) List<ElasticSearchIndexStrategy> strategies) {
        if (strategies != null) {
            strategies.forEach(this::registerStrategy);
        }
    }

    @Override
    public Mono<Void> putIndex(ElasticSearchIndexMetadata index) {
        return this.getIndexStrategy(index.getIndex()).flatMap(strategy -> strategy.putIndex(index)).doOnNext(idx -> this.indexMetadataStore.put(idx.getIndex(), (ElasticSearchIndexMetadata)idx)).then();
    }

    @Override
    public Mono<ElasticSearchIndexMetadata> getIndexMetadata(String index) {
        return Mono.justOrEmpty((Object)this.indexMetadataStore.get(index)).switchIfEmpty(Mono.defer(() -> this.doLoadMetaData(index).doOnNext(metadata -> this.indexMetadataStore.put(metadata.getIndex(), (ElasticSearchIndexMetadata)metadata))));
    }

    protected Mono<ElasticSearchIndexMetadata> doLoadMetaData(String index) {
        return this.getIndexStrategy(index).flatMap(strategy -> strategy.loadIndexMetadata(index));
    }

    @Override
    public Mono<ElasticSearchIndexStrategy> getIndexStrategy(String index) {
        return Mono.justOrEmpty((Object)this.strategies.get(this.indexUseStrategy.getOrDefault(index.toLowerCase(), this.defaultStrategy))).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("[" + index + "] \u4e0d\u652f\u6301\u4efb\u4f55\u7d22\u5f15\u7b56\u7565")));
    }

    @Override
    public void useStrategy(String index, String strategy) {
        this.indexUseStrategy.put(index, strategy);
    }

    @Override
    public void registerStrategy(ElasticSearchIndexStrategy strategy) {
        this.strategies.put(strategy.getId(), strategy);
    }

    public String getDefaultStrategy() {
        return this.defaultStrategy;
    }

    public void setDefaultStrategy(String defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
    }

    public Map<String, String> getIndexUseStrategy() {
        return this.indexUseStrategy;
    }

    public void setIndexUseStrategy(Map<String, String> indexUseStrategy) {
        this.indexUseStrategy = indexUseStrategy;
    }
}

