/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.aggreation.bucket;

import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.community.elastic.search.aggreation.bucket.Ranges;
import org.jetlinks.community.elastic.search.aggreation.bucket.Sort;
import org.jetlinks.community.elastic.search.aggreation.enums.BucketType;
import org.jetlinks.community.elastic.search.aggreation.metrics.MetricsAggregationStructure;

public class BucketAggregationsStructure {
    @NonNull
    private String field;
    private String name;
    @NonNull
    private BucketType type = BucketType.TERMS;
    private Integer size;
    private Sort sort;
    private List<Ranges> ranges;
    private LongBounds extendedBounds;
    private String format;
    private String interval;
    private Object missingValue;
    private List<MetricsAggregationStructure> subMetricsAggregation = new LinkedList<MetricsAggregationStructure>();
    private List<BucketAggregationsStructure> subBucketAggregation = new LinkedList<BucketAggregationsStructure>();

    public String getName() {
        if (StringUtils.isNullOrEmpty((Object)this.name)) {
            this.name = this.type.name().concat("_").concat(this.field);
        }
        return this.name;
    }

    public static BucketAggregationsStructureBuilder builder() {
        return new BucketAggregationsStructureBuilder();
    }

    public void setField(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.field = field;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(@NonNull BucketType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public void setRanges(List<Ranges> ranges) {
        this.ranges = ranges;
    }

    public void setExtendedBounds(LongBounds extendedBounds) {
        this.extendedBounds = extendedBounds;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public void setMissingValue(Object missingValue) {
        this.missingValue = missingValue;
    }

    public void setSubMetricsAggregation(List<MetricsAggregationStructure> subMetricsAggregation) {
        this.subMetricsAggregation = subMetricsAggregation;
    }

    public void setSubBucketAggregation(List<BucketAggregationsStructure> subBucketAggregation) {
        this.subBucketAggregation = subBucketAggregation;
    }

    @NonNull
    public String getField() {
        return this.field;
    }

    @NonNull
    public BucketType getType() {
        return this.type;
    }

    public Integer getSize() {
        return this.size;
    }

    public Sort getSort() {
        return this.sort;
    }

    public List<Ranges> getRanges() {
        return this.ranges;
    }

    public LongBounds getExtendedBounds() {
        return this.extendedBounds;
    }

    public String getFormat() {
        return this.format;
    }

    public String getInterval() {
        return this.interval;
    }

    public Object getMissingValue() {
        return this.missingValue;
    }

    public List<MetricsAggregationStructure> getSubMetricsAggregation() {
        return this.subMetricsAggregation;
    }

    public List<BucketAggregationsStructure> getSubBucketAggregation() {
        return this.subBucketAggregation;
    }

    public BucketAggregationsStructure(@NonNull String field, String name, @NonNull BucketType type, Integer size, Sort sort, List<Ranges> ranges, LongBounds extendedBounds, String format, String interval, Object missingValue, List<MetricsAggregationStructure> subMetricsAggregation, List<BucketAggregationsStructure> subBucketAggregation) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.field = field;
        this.name = name;
        this.type = type;
        this.size = size;
        this.sort = sort;
        this.ranges = ranges;
        this.extendedBounds = extendedBounds;
        this.format = format;
        this.interval = interval;
        this.missingValue = missingValue;
        this.subMetricsAggregation = subMetricsAggregation;
        this.subBucketAggregation = subBucketAggregation;
    }

    public BucketAggregationsStructure() {
    }

    public static class BucketAggregationsStructureBuilder {
        private String field;
        private String name;
        private BucketType type;
        private Integer size;
        private Sort sort;
        private List<Ranges> ranges;
        private LongBounds extendedBounds;
        private String format;
        private String interval;
        private Object missingValue;
        private List<MetricsAggregationStructure> subMetricsAggregation;
        private List<BucketAggregationsStructure> subBucketAggregation;

        BucketAggregationsStructureBuilder() {
        }

        public BucketAggregationsStructureBuilder field(@NonNull String field) {
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.field = field;
            return this;
        }

        public BucketAggregationsStructureBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BucketAggregationsStructureBuilder type(@NonNull BucketType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public BucketAggregationsStructureBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public BucketAggregationsStructureBuilder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public BucketAggregationsStructureBuilder ranges(List<Ranges> ranges) {
            this.ranges = ranges;
            return this;
        }

        public BucketAggregationsStructureBuilder extendedBounds(LongBounds extendedBounds) {
            this.extendedBounds = extendedBounds;
            return this;
        }

        public BucketAggregationsStructureBuilder format(String format) {
            this.format = format;
            return this;
        }

        public BucketAggregationsStructureBuilder interval(String interval) {
            this.interval = interval;
            return this;
        }

        public BucketAggregationsStructureBuilder missingValue(Object missingValue) {
            this.missingValue = missingValue;
            return this;
        }

        public BucketAggregationsStructureBuilder subMetricsAggregation(List<MetricsAggregationStructure> subMetricsAggregation) {
            this.subMetricsAggregation = subMetricsAggregation;
            return this;
        }

        public BucketAggregationsStructureBuilder subBucketAggregation(List<BucketAggregationsStructure> subBucketAggregation) {
            this.subBucketAggregation = subBucketAggregation;
            return this;
        }

        public BucketAggregationsStructure build() {
            return new BucketAggregationsStructure(this.field, this.name, this.type, this.size, this.sort, this.ranges, this.extendedBounds, this.format, this.interval, this.missingValue, this.subMetricsAggregation, this.subBucketAggregation);
        }

        public String toString() {
            return "BucketAggregationsStructure.BucketAggregationsStructureBuilder(field=" + this.field + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", size=" + this.size + ", sort=" + this.sort + ", ranges=" + this.ranges + ", extendedBounds=" + this.extendedBounds + ", format=" + this.format + ", interval=" + this.interval + ", missingValue=" + this.missingValue + ", subMetricsAggregation=" + this.subMetricsAggregation + ", subBucketAggregation=" + this.subBucketAggregation + ")";
        }
    }
}

