/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.measurements.sys;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetlinks.community.dashboard.measurements.sys.MonitorInfo;
import org.jetlinks.community.dashboard.measurements.sys.MonitorUtils;

public class MemoryInfo
implements MonitorInfo<MemoryInfo> {
    private static final long serialVersionUID = 1L;
    @Schema(description="JVM\u5806\u603b\u5185\u5b58,\u5355\u4f4dMB")
    private long jvmHeapTotal;
    @Schema(description="JVM\u5806\u53ef\u7528\u5185\u5b58,\u5355\u4f4dMB")
    private long jvmHeapFree;
    @Schema(description="JVM\u5806\u5916\u603b\u5185\u5b58,\u5355\u4f4dMB")
    private long jvmNonHeapTotal;
    @Schema(description="JVM\u5806\u5916\u53ef\u7528\u5185\u5b58,\u5355\u4f4dMB")
    private long jvmNonHeapFree;
    @Schema(description="\u7cfb\u7edf\u603b\u5185\u5b58,\u5355\u4f4dMB")
    private long systemTotal;
    @Schema(description="\u7cfb\u7edf\u53ef\u7528\u5185\u5b58,\u5355\u4f4dMB")
    private long systemFree;

    public float getJvmHeapUsage() {
        return MonitorUtils.round((float)(this.jvmHeapTotal - this.jvmHeapFree) / (float)this.jvmHeapTotal * 100.0f);
    }

    public float getJvmNonHeapUsage() {
        return MonitorUtils.round((float)(this.jvmNonHeapTotal - this.jvmNonHeapFree) / (float)this.jvmNonHeapTotal * 100.0f);
    }

    public float getSystemUsage() {
        return MonitorUtils.round((float)(this.systemTotal - this.systemFree) / (float)this.systemTotal * 100.0f);
    }

    @Override
    public MemoryInfo add(MemoryInfo info) {
        return new MemoryInfo(info.jvmHeapTotal + this.jvmHeapTotal, info.jvmHeapFree + this.jvmHeapFree, info.jvmNonHeapTotal + this.jvmNonHeapTotal, info.jvmNonHeapFree + this.jvmNonHeapFree, info.systemTotal + this.systemTotal, info.systemFree + this.systemFree);
    }

    @Override
    public MemoryInfo division(int num) {
        return new MemoryInfo(this.jvmHeapTotal / (long)num, this.jvmHeapFree / (long)num, this.jvmNonHeapTotal / (long)num, this.jvmNonHeapFree / (long)num, this.systemTotal / (long)num, this.systemFree / (long)num);
    }

    public long getJvmHeapTotal() {
        return this.jvmHeapTotal;
    }

    public long getJvmHeapFree() {
        return this.jvmHeapFree;
    }

    public long getJvmNonHeapTotal() {
        return this.jvmNonHeapTotal;
    }

    public long getJvmNonHeapFree() {
        return this.jvmNonHeapFree;
    }

    public long getSystemTotal() {
        return this.systemTotal;
    }

    public long getSystemFree() {
        return this.systemFree;
    }

    public void setJvmHeapTotal(long jvmHeapTotal) {
        this.jvmHeapTotal = jvmHeapTotal;
    }

    public void setJvmHeapFree(long jvmHeapFree) {
        this.jvmHeapFree = jvmHeapFree;
    }

    public void setJvmNonHeapTotal(long jvmNonHeapTotal) {
        this.jvmNonHeapTotal = jvmNonHeapTotal;
    }

    public void setJvmNonHeapFree(long jvmNonHeapFree) {
        this.jvmNonHeapFree = jvmNonHeapFree;
    }

    public void setSystemTotal(long systemTotal) {
        this.systemTotal = systemTotal;
    }

    public void setSystemFree(long systemFree) {
        this.systemFree = systemFree;
    }

    public String toString() {
        return "MemoryInfo(jvmHeapTotal=" + this.getJvmHeapTotal() + ", jvmHeapFree=" + this.getJvmHeapFree() + ", jvmNonHeapTotal=" + this.getJvmNonHeapTotal() + ", jvmNonHeapFree=" + this.getJvmNonHeapFree() + ", systemTotal=" + this.getSystemTotal() + ", systemFree=" + this.getSystemFree() + ")";
    }

    public MemoryInfo(long jvmHeapTotal, long jvmHeapFree, long jvmNonHeapTotal, long jvmNonHeapFree, long systemTotal, long systemFree) {
        this.jvmHeapTotal = jvmHeapTotal;
        this.jvmHeapFree = jvmHeapFree;
        this.jvmNonHeapTotal = jvmNonHeapTotal;
        this.jvmNonHeapFree = jvmNonHeapFree;
        this.systemTotal = systemTotal;
        this.systemFree = systemFree;
    }

    public MemoryInfo() {
    }
}

